#ifndef MENU_H
#define MENU_H

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"

/** Menu Class
 * @brief class for containing menu screens
 * @author Adam P. Baker
 * @date 9 May 2019
 */
class Menu
{
public:
    /** Constructor */
    Menu();

    /** Deconstructor */
    ~Menu();

    /** intialises */
    void init();

    /** runs the title sequence
    *@param N5110 class which controlls lcd screen
    *@param Gamepad class for working with the gamepad
    */
    void title_intro(N5110 &lcd, Gamepad &pad);

    /**holds title screen and flashes 'press start'
    *@param N5110 class which controlls lcd screen
    *@param Gamepad class for working with the gamepad
    *@returns _start (1 when pressed, else 0) (int)
    */
    int press_start(N5110 &lcd, Gamepad &pad);

    /** displays main menu screen and takes in input to select next state
    *@param Gamepad class for working with the gamepad
    *@param N5110 class which controlls lcd screen
    *@returns _input (1 when pressed, else 0) (int)
    */
    int select_input_main(Gamepad &pad, N5110 &lcd);

    /** displays continue menu screen and takes in input to select next state
    *@param Gamepad class for working with the gamepad
    *@param N5110 class which controlls lcd screen
    *@returns _input (1 when pressed, else 0) (int)
    */
    int select_input_continue(Gamepad &pad, N5110 &lcd);

    /** displays highscore screen
    *@param N5110 class which controlls lcd screen
    *@param highest level reached by user (int)
    */
    void print_highscore(N5110 &lcd, int highscore);

    /** displays continue menu screen and takes in input to select next state
    *@param Gamepad class for working with the gamepad
    *@param N5110 class which controlls lcd screen
    *@returns contrast level (float)
    */
    float print_settings(Gamepad &pad, N5110 &lcd);
private:

    void print_main_menu(N5110 &lcd);                               //prints menu class visuals
    void print_continue_menu(N5110 &lcd);                           //prints continue class visuals

    void menu_decoration(N5110 &lcd);                               //prints menu border decoration

    void intro_b(N5110 &lcd, Gamepad &pad);                         //display b with note
    void intro_bl(N5110 &lcd, Gamepad &pad);                        //display bl with note
    void intro_blo(N5110 &lcd, Gamepad &pad);                       //display blo with note
    void intro_bloc(N5110 &lcd, Gamepad &pad);                      //display bloc with note
    void intro_block(N5110 &lcd, Gamepad &pad);                     //display block  with note
    void intro_block_h(N5110 &lcd, Gamepad &pad);                   //display block h with note
    void intro_block_he(N5110 &lcd, Gamepad &pad);                  //display block he with note
    void intro_block_hea(N5110 &lcd, Gamepad &pad);                 //display block hea with note
    void intro_block_head(N5110 &lcd, Gamepad &pad);                //display block head with note

    void B(int x, int y, N5110 &lcd);                               //prints B HEAD sprite
    void BL(int x, int y, N5110 &lcd);                              //prints BL sprite
    void BLO(int x, int y, N5110 &lcd);                             //prints BLO sprite
    void BLOC(int x, int y, N5110 &lcd);                            //prints BLOC sprite
    void BLOCK(int x, int y, N5110 &lcd);                           //prints BLOCK  sprite
    void BLOCK_H(int x, int y, N5110 &lcd);                         //prints BLOCK H sprite
    void BLOCK_HE(int x, int y, N5110 &lcd);                        //prints BLOCK HE sprite
    void BLOCK_HEA(int x, int y, N5110 &lcd);                       //prints BLOCK HEA sprite
    void BLOCK_HEAD(int x, int y, N5110 &lcd);                      //prints BLOCK HEAD sprite

    int _start;
    int _count;

    int _select;
    int _input;
    int _stop;
    bool _flash;

};

#endif