#ifndef ANIMATION_H
#define ANIMATION_H

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"

/** Animation Class
 * @brief Class containg sprites for animating blockhead
 * @author Adam P. Baker
 * @date 9 May 2019
 */
class Animation
{
public:
    /** Constructor */
    Animation();
    
    /** Deconstructor */
    ~Animation();
    
    /** displays standing sprite
    *@param x cordinate of sprite position (int)
    *@param y cordinate of sprite position (int)
    *@param N5110 class which controlls lcd screen
    */
    void standing(int x, int y, N5110 &lcd);
    
    /** displays running right sprite one
    *@param x cordinate of sprite position (int)
    *@param y cordinate of sprite position (int)
    *@param N5110 class which controlls lcd screen
    */
    void runRightOne(int x, int y, N5110 &lcd);
    
    /** displays running right sprite two
    *@param x cordinate of sprite position (int)
    *@param y cordinate of sprite position (int)
    *@param N5110 class which controlls lcd screen
    */
    void runRightTwo(int x, int y, N5110 &lcd);
    
    /** display running left sprite one
    *@param x cordinate of sprite position (int)
    *@param y cordinate of sprite position (int)
    *@param N5110 class which controlls lcd screen
    */
    void runLeftOne(int x, int y, N5110 &lcd);
    
    /** displays running left sprite two
    *@param x cordinate of sprite position (int)
    *@param y cordinate of sprite position (int)
    *@param N5110 class which controlls lcd screen
    */
    void runLeftTwo(int x, int y, N5110 &lcd);
    
    /** displays walking right sprite one
    *@param x cordinate of sprite position (int)
    *@param y cordinate of sprite position (int)
    *@param N5110 class which controlls lcd screen
    */
    void walkRightOne(int x, int y, N5110 &lcd);
    
    /** displays walking right sprite two
    *@param x cordinate of sprite position (int)
    *@param y cordinate of sprite position (int)
    *@param N5110 class which controlls lcd screen
    */
    void walkRightTwo(int x, int y, N5110 &lcd);
    
    /** displays walking right sprite three
    *@param x cordinate of sprite position (int)
    *@param y cordinate of sprite position (int)
    *@param N5110 class which controlls lcd screen
    */
    void walkRightThree(int x, int y, N5110 &lcd);
    
    /** displays walking right sprite four
    *@param x cordinate of sprite position (int)
    *@param y cordinate of sprite position (int)
    *@param N5110 class which controlls lcd screen
    */
    void walkRightFour(int x, int y, N5110 &lcd);

    /** displays walking left sprite one
    *@param x cordinate of sprite position (int)
    *@param y cordinate of sprite position (int)
    *@param N5110 class which controlls lcd screen
    */
    void walkLeftOne(int x, int y, N5110 &lcd);
    
    /** displays walking left sprite two
    *@param x cordinate of sprite position (int)
    *@param y cordinate of sprite position (int)
    *@param N5110 class which controlls lcd screen
    */
    void walkLeftTwo(int x, int y, N5110 &lcd);
    
    /** displays walking left sprite three
    *@param x cordinate of sprite position (int)
    *@param y cordinate of sprite position (int)
    *@param N5110 class which controlls lcd screen
    */
    void walkLeftThree(int x, int y, N5110 &lcd);
    
    /** displays walking left sprte four
    *@param x cordinate of sprite position (int)
    *@param y cordinate of sprite position (int)
    *@param N5110 class which controlls lcd screen
    */
    void walkLeftFour(int x, int y, N5110 &lcd);

    /** displays death sprite one
    *@param x cordinate of sprite position (int)
    *@param y cordinate of sprite position (int)
    *@param N5110 class which controlls lcd screen
    */
    void deathOne(int x, int y, N5110 &lcd);
    
    /** displays death sprite two
    *@param x cordinate of sprite position (int)
    *@param y cordinate of sprite position (int)
    *@param N5110 class which controlls lcd screen
    */
    void deathTwo(int x, int y, N5110 &lcd);
    
    /** displays death sprite three
    *@param x cordinate of sprite position (int)
    *@param y cordinate of sprite position (int)
    *@param N5110 class which controlls lcd screen
    */
    void deathThree(int x, int y, N5110 &lcd);
    
    /** displays death sprite four
    *@param x cordinate of sprite position (int)
    *@param y cordinate of sprite position (int)
    *@param N5110 class which controlls lcd screen
    */
    void deathFour(int x, int y, N5110 &lcd);
    
    /** displays falling sprite
    *@param x cordinate of sprite position (int)
    *@param y cordinate of sprite position (int)
    *@param N5110 class which controlls lcd screen
    */
    void falling(int x, int y, N5110 &lcd);
    
    /** displays falling left sprite
    *@param x cordinate of sprite position (int)
    *@param y cordinate of sprite position (int)
    *@param N5110 class which controlls lcd screen
    */
    void fallingLeft(int x, int y, N5110 &lcd);
    
    /** displays falling right sprite
    *@param x cordinate of sprite position (int)
    *@param y cordinate of sprite position (int)
    *@param N5110 class which controlls lcd screen
    */
    void fallingRight(int x, int y, N5110 &lcd);
    
    /** displays wall cling right sprite
    *@param x cordinate of sprite position (int)
    *@param y cordinate of sprite position (int)
    *@param N5110 class which controlls lcd screen
    */
    void wallclingRight(int x, int y, N5110 &lcd);
    
    /** displays wall cling left sprite
    *@param x cordinate of sprite position (int)
    *@param y cordinate of sprite position (int)
    *@param N5110 class which controlls lcd screen
    */
    void wallclingLeft(int x, int y, N5110 &lcd);
    
    /** checks if pixels below blockhead 
    *@param x cordinate of blockhead (int)
    *@param y cordinate of blockhead (int)
    *@param N5110 class which controlls lcd screen
    *@retunrs true if pixels below
    */
    bool pixelsDown(int x, int y, N5110 &lcd);
    
    /** checks if pixels above blockhead
    *@param x cordinate of blockhead (int)
    *@param y cordinate of blockhead (int)
    *@param N5110 class which controlls lcd screen
    *@retunrs true if pixels above
    */
    bool pixelsUp(int x, int y, N5110 &lcd);
    
    /** checks if pixels left of blockhead
    *@param x cordinate of blockhead (int)
    *@param y cordinate of blockhead (int)
    *@param N5110 class which controlls lcd screen
    *@retunrs true if pixels left
    */
    bool pixelsLeft(int x, int y, N5110 &lcd);
    
    /** checks if pixels right of blockhead
    *@param x cordinate of blockhead (int)
    *@param y cordinate of blockhead (int)
    *@param N5110 class which controlls lcd screen
    *@retunrs true if pixels right
    */
    bool pixelsRight(int x, int y, N5110 &lcd);

private:

};

#endif

