#include "Animation.h"

// nothing doing in the constructor and destructor
Animation::Animation()
{

}



Animation::~Animation()
{

}



void Animation::standing(int x, int y, N5110 &lcd)                        //displays standing sprite
{
    
    const int standing[12][9] =   {
    
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,0,0,0,0,0,0},
        {1,0,1,1,1,1,1,0,1},
        {1,0,1,1,1,1,1,0,1},
        {1,0,1,1,1,1,1,0,1},
        {1,0,1,1,1,1,1,0,1},
        {0,0,1,0,0,0,1,0,0},
        {0,0,1,0,0,0,1,0,0},
        {0,0,1,0,0,0,1,0,0},
        {0,0,1,0,0,0,1,0,0},

    };

    lcd.drawSprite(x,y,12,9,(int *)standing);
    
}



void Animation::runRightOne(int x, int y, N5110 &lcd)                    //displays running right sprite one
{
    
    const int runRightOne[12][9] =   {
    
        {0,0,0,0,1,1,1,0,0},
        {0,0,0,0,1,1,1,0,0},
        {0,0,0,0,1,1,1,0,0},
        {1,1,1,0,0,0,0,0,0},
        {1,0,1,1,1,1,1,0,0},
        {1,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,1,1},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,0,0,0,0,1,0},
        {0,0,1,0,0,0,0,1,0},
        {1,1,0,0,0,0,0,0,1},
        {0,0,0,0,0,0,0,0,1},

    };

    lcd.drawSprite(x,y,12,9,(int *)runRightOne);
    
}



void Animation::runRightTwo(int x, int y, N5110 &lcd)                   //displays running right sprite two
{
    
    const int runRightTwo[12][9] =   {
    
        {0,0,0,0,1,1,1,0,0},
        {0,0,0,0,1,1,1,0,0},
        {0,0,0,0,1,1,1,0,0},
        {0,0,0,0,0,0,0,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,0,0,0},
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,0,1,0,0,0,0},
        {0,0,0,0,1,0,0,0,0},

    };

    lcd.drawSprite(x,y,12,9,(int *)runRightTwo);
    
}



void Animation::runLeftOne(int x, int y, N5110 &lcd)                    //display running left sprite one
{
    
    const int runLeftOne[12][9] =   {
    
        {0,0,1,1,1,0,0,0,0},
        {0,0,1,1,1,0,0,0,0},
        {0,0,1,1,1,0,0,0,0},
        {0,0,0,0,0,0,1,1,1},
        {0,0,1,1,1,1,1,0,1},
        {0,0,1,1,1,1,1,0,1},
        {1,1,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,1,0,0,0,0,1,0,0},
        {0,1,0,0,0,0,1,0,0},
        {1,0,0,0,0,0,0,1,1},
        {1,0,0,0,0,0,0,0,0},

    };

    lcd.drawSprite(x,y,12,9,(int *)runLeftOne);
    
}



void Animation::runLeftTwo(int x, int y, N5110 &lcd)                    //displays running left sprite two
{
    
    const int runLeftTwo[12][9] =   {
    
        {0,0,1,1,1,0,0,0,0},
        {0,0,1,1,1,0,0,0,0},
        {0,0,1,1,1,0,0,0,0},
        {0,0,0,0,0,0,0,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,0,1,1,1,1,0,0},
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,0,1,0,0,0,0},
        {0,0,0,0,1,0,0,0,0},

    };

    lcd.drawSprite(x,y,12,9,(int *)runLeftTwo);
    
}



void Animation::walkRightOne(int x, int y, N5110 &lcd)                  //displays walking right sprite one
{
    
    const int walkRightOne[12][9] =   {
    
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,0,0,0,0,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,1,1,1,1,1,1,0,0},
        {0,1,1,1,1,1,1,1,0},
        {0,1,1,1,1,1,1,0,0},
        {0,0,1,0,0,0,1,0,0},
        {0,0,1,0,0,0,1,0,0},
        {0,0,1,0,0,0,1,0,0},
        {0,1,0,0,0,0,1,0,0},

    };

    lcd.drawSprite(x,y,12,9,(int *)walkRightOne);
    
}



void Animation::walkRightTwo(int x, int y, N5110 &lcd)                  //displays walking right sprite two
{
    
    const int walkRightTwo[12][9] =   {
    
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,0,0,0,0,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,1,1,1,1,1,1,0,0},
        {0,1,1,1,1,1,1,1,0},
        {0,1,1,1,1,1,1,0,0},
        {0,0,0,1,0,1,0,0,0},
        {0,0,0,1,0,1,0,0,0},
        {0,1,1,0,0,1,0,0,0},
        {0,0,0,0,0,1,0,0,0},

    };

    lcd.drawSprite(x,y,12,9,(int *)walkRightTwo);
    
}



void Animation::walkRightThree(int x, int y, N5110 &lcd)                //displays walking right sprite three
{
    
    const int walkRightThree[12][9] =   {
    
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,0,0,0,0,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,0,0,1,1,0,0,0},
        {0,0,0,0,1,1,0,0,0},
        {0,0,0,1,1,0,0,0,0},
        {0,0,0,0,1,0,0,0,0},

    };

    lcd.drawSprite(x,y,12,9,(int *)walkRightThree);
    
}



void Animation::walkRightFour(int x, int y, N5110 &lcd)                 //displays walking right sprite four
{
    
    const int walkRightFour[12][9] =   {
    
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,0,0,0,0,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,0,1,0,0,1,0,0},
        {0,0,0,1,0,0,1,0,0},
        {0,0,0,1,0,1,0,0,0},
        {0,0,0,1,0,1,0,0,0},

    };

    lcd.drawSprite(x,y,12,9,(int *)walkRightFour);
    
}



void Animation::walkLeftOne(int x, int y, N5110 &lcd)                   //displays walking left sprite one
{
    
    const int walkLeftOne[12][9] =   {
    
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,0,0,0,0,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,1,0},
        {0,1,1,1,1,1,1,1,0},
        {0,0,1,1,1,1,1,1,0},
        {0,0,1,0,0,0,1,0,0},
        {0,0,1,0,0,0,1,0,0},
        {0,0,1,0,0,0,1,0,0},
        {0,0,1,0,0,0,0,1,0},

    };

    lcd.drawSprite(x,y,12,9,(int *)walkLeftOne);
    
}



void Animation::walkLeftTwo(int x, int y, N5110 &lcd)                   //displays walking left sprite two
{
    
    const int walkLeftTwo[12][9] =   {
    
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,0,0,0,0,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,1,0},
        {0,1,1,1,1,1,1,1,0},
        {0,0,1,1,1,1,1,1,0},
        {0,0,0,1,0,1,0,0,0},
        {0,0,0,1,0,1,0,0,0},
        {0,0,0,1,0,0,1,1,0},
        {0,0,0,1,0,0,0,0,0},

    };

    lcd.drawSprite(x,y,12,9,(int *)walkLeftTwo);
    
}



void Animation::walkLeftThree(int x, int y, N5110 &lcd)                 //displays walking left sprite three
{
    
    const int walkLeftThree[12][9] =   {
    
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,0,0,0,0,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,0,1,1,0,0,0,0},
        {0,0,0,1,1,0,0,0,0},
        {0,0,0,0,1,1,0,0,0},
        {0,0,0,0,1,0,0,0,0},

    };

    lcd.drawSprite(x,y,12,9,(int *)walkLeftThree);
    
}



void Animation::walkLeftFour(int x, int y, N5110 &lcd)                  //displays walking left sprte four
{
    
    const int walkLeftFour[12][9] =   {
    
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,1,1,1,0,0,0},
        {0,0,0,0,0,0,0,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,0,0,1,0,0,0},
        {0,0,1,0,0,1,0,0,0},
        {0,0,0,1,0,1,0,0,0},
        {0,0,0,1,0,1,0,0,0},

    };

    lcd.drawSprite(x,y,12,9,(int *)walkLeftFour);                       
    
}



void Animation::falling(int x, int y, N5110 &lcd)                       //displays falling sprite
{
    
    const int falling[12][9] =   {
        {1,0,0,1,1,1,0,0,1},
        {1,0,0,1,1,1,0,0,1},
        {1,0,0,1,1,1,0,0,1},
        {1,0,0,0,0,0,0,0,1},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,0,0,0,1,0,0},
        {0,0,1,0,0,0,1,0,0},
        {0,0,1,0,0,0,1,0,0},
        {0,0,1,0,0,0,1,0,0},

    };

     lcd.drawSprite(x,y,12,9,(int *)falling);
    
}



void Animation::fallingLeft(int x, int y, N5110 &lcd)                   //displays falling left sprite
{
    
    const int fallingLeft[12][9] =   {
        {1,0,1,1,1,0,0,0,1},
        {1,0,1,1,1,0,0,0,1},
        {1,0,1,1,1,0,0,0,1},
        {1,0,0,0,0,0,0,0,1},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,1,0,0,0,1,0,0,0},
        {0,1,0,0,0,1,0,0,0},
        {0,0,1,0,0,0,1,0,0},
        {0,0,0,1,0,0,0,1,0},

    };

    lcd.drawSprite(x,y,12,9,(int *)fallingLeft);
    
}



void Animation::fallingRight(int x, int y, N5110 &lcd)                  //displays falling right sprite
{
    
    const int fallingRight[12][9] =   {
        {1,0,0,0,1,1,1,0,1},
        {1,0,0,0,1,1,1,0,1},
        {1,0,0,0,1,1,1,0,1},
        {1,0,0,0,0,0,0,0,1},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0},
        {0,0,0,1,0,0,0,1,0},
        {0,0,0,1,0,0,0,1,0},
        {0,0,1,0,0,0,1,0,0},
        {0,0,1,0,0,0,1,0,0},

    };

    lcd.drawSprite(x,y,12,9,(int *)fallingRight);
    
}



void Animation::wallclingLeft(int x, int y, N5110 &lcd)                 //displays wall cligh left sprite 
{
    
    const int wallclingLeft[12][9] =   {
        {1,0,1,1,1,0,0,0,0},
        {1,0,1,1,1,0,0,0,0},
        {1,0,1,1,1,0,0,0,0},
        {0,0,0,0,0,0,0,0,0},
        {1,1,1,1,1,0,0,0,0},
        {1,1,1,1,1,0,0,0,0},
        {1,1,1,1,1,0,1,0,0},
        {1,1,1,1,1,0,1,0,0},
        {0,1,0,1,0,0,0,0,0},
        {1,0,0,1,0,0,0,0,0},
        {1,0,1,0,0,0,0,0,0},
        {1,1,0,0,0,0,0,0,0},

    };

    lcd.drawSprite(x,y,12,9,(int *)wallclingLeft);
    
}



void Animation::wallclingRight(int x, int y, N5110 &lcd)                //displays wall cling right sprite
{
    
    const int wallclingLeft[12][9] =   {
        {0,0,0,0,1,1,1,0,1},
        {0,0,0,0,1,1,1,0,1},
        {0,0,0,0,1,1,1,0,1},
        {0,0,0,0,0,0,0,0,0},
        {0,0,0,0,1,1,1,1,1},
        {0,0,0,0,1,1,1,1,1},
        {0,0,1,0,1,1,1,1,1},
        {0,0,1,0,1,1,1,1,1},
        {0,0,0,0,0,1,0,1,0},
        {0,0,0,0,0,1,0,0,1},
        {0,0,0,0,0,0,1,0,1},
        {0,0,0,0,0,0,0,1,1},

    };

    lcd.drawSprite(x,y,12,9,(int *)wallclingLeft);
    
}



void Animation::deathOne(int x, int y, N5110 &lcd)                      //displays death sprite one
{
    
    const int deathOne[12][9] =   {
    
        {0,0,0,1,0,1,0,0,0},
        {0,0,0,1,1,1,0,0,0},
        {0,1,0,0,1,1,0,0,0},
        {1,0,0,0,0,0,0,0,1},
        {0,0,1,1,1,1,1,0,1},
        {1,0,0,1,1,1,1,0,0},
        {1,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,1},
        {0,0,1,0,0,0,1,0,0},
        {0,0,0,0,0,0,0,0,0},
        {0,0,1,0,0,0,0,0,0},
        {0,0,0,0,0,0,1,0,0},

    };

    lcd.drawSprite(x,y,12,9,(int *)deathOne);
    
}



void Animation::deathTwo(int x, int y, N5110 &lcd)                      //displays death sprite two
{
    
    const int deathTwo[10][8] =   {
    
        {0,0,0,0,0,1,0,0,},
        {0,0,1,1,1,0,0,0,},
        {0,0,0,0,1,0,0,1,},
        {0,0,0,0,0,0,0,0,},
        {0,0,1,1,1,1,0,0,},
        {0,0,0,1,1,1,1,0,},
        {0,1,1,1,1,1,1,0,},
        {0,0,1,1,0,1,1,1,},
        {0,0,1,0,0,0,1,0,},
        {0,0,0,1,0,0,0,0,},
      

    };

    lcd.drawSprite(x,y,10,8,(int *)deathTwo);
    
}



void Animation::deathThree(int x, int y, N5110 &lcd)                    //displays death sprite three
{
    
    const int deathThree[9][7] =   {
    
        {0,0,0,0,0,0,0,},
        {0,0,0,1,0,0,0,},
        {0,0,0,0,1,0,0,},
        {0,0,0,0,0,0,0,},
        {0,0,0,1,1,1,0,},
        {0,0,0,1,0,1,1,},
        {0,0,1,1,1,0,1,},
        {0,0,0,1,0,1,0,},
        {0,0,1,0,0,0,0,},
        

    };

    lcd.drawSprite(x,y,9,7,(int *)deathThree);
    
}



void Animation::deathFour(int x, int y, N5110 &lcd)                     //displays death sprite four
{
    
    const int deathFour[8][6] =   {
    
        {0,0,0,0,0,0,},
        {0,0,0,0,0,0,},
        {0,0,0,0,0,0,},
        {0,0,0,0,0,0,},
        {0,0,0,1,0,0,},
        {0,0,0,0,0,1,},
        {0,0,0,1,1,0,},
        {0,0,0,1,0,1,},
       

    };

    lcd.drawSprite(x,y,8,6,(int *)deathFour);
    
}


//output true if pixels beneath runner
bool Animation::pixelsDown(int x, int y, N5110 &lcd)                    
{

    if (lcd.getPixel(x,y+12) || lcd.getPixel(x+1,y+12) || lcd.getPixel(x+2,y+12) || lcd.getPixel(x+3,y+12) || lcd.getPixel(x+4,y+12) || lcd.getPixel(x+5,y+12) || lcd.getPixel(x+6,y+12) || lcd.getPixel(x+7,y+12) || lcd.getPixel(x+8,y+12)) {
        return true;
    } else {
        return false;
    }

}


//output true if pixels above runner
bool Animation::pixelsUp(int x, int y, N5110 &lcd)                      
{

    if (lcd.getPixel(x,y-1) || lcd.getPixel(x+1,y-1) || lcd.getPixel(x+2,y-1) || lcd.getPixel(x+3,y-1) || lcd.getPixel(x+4,y-1) || lcd.getPixel(x+5,y-1) || lcd.getPixel(x+6,y-1) || lcd.getPixel(x+7,y-1) || lcd.getPixel(x+8,y-1)) {
        return true;
    } else {
        return false;
    }
}


//output true if pixels left of runner
bool Animation::pixelsLeft(int x, int y, N5110 &lcd)                    
{

    if (lcd.getPixel(x-1,y) || lcd.getPixel(x-1,y+1) || lcd.getPixel(x-1,y+2) || lcd.getPixel(x-1,y+3) || lcd.getPixel(x-1,y+4) || lcd.getPixel(x-1,y+5) || lcd.getPixel(x-1,y+6) || lcd.getPixel(x-1,y+7) || lcd.getPixel(x-1,y+8) || lcd.getPixel(x-1,y+9) || lcd.getPixel(x-1,y+10) || lcd.getPixel(x-1,y+11)) {
        return true;
    } else {
        return false;
    }
} 


//output true if pixels right of runner
bool Animation::pixelsRight(int x, int y, N5110 &lcd)                  
{

    if (lcd.getPixel(x+9,y) || lcd.getPixel(x+9,y+1) || lcd.getPixel(x+9,y+2) || lcd.getPixel(x+9,y+3) || lcd.getPixel(x+9,y+4) || lcd.getPixel(x+9,y+5) || lcd.getPixel(x+9,y+6) || lcd.getPixel(x+9,y+7) || lcd.getPixel(x+9,y+8) || lcd.getPixel(x+9,y+9) || lcd.getPixel(x+9,y+10) || lcd.getPixel(x+9,y+11)) {
        return true;
    } else {
        return false;
    }
} 
