#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Levels.h"



// nothing doing in the constructor and destructor
Levels::Levels()
{

}

Levels::~Levels()
{

}


//initializes all variables and pos struct.
Pos Levels::init(Pos pos)           
{

    pos = init_hoz1(pos);            //initialises hoz1 part of struct
    pos = init_hoz2(pos);            //initialises hoz2 part of struct
    pos = init_ver1(pos);            //initialises ver1 part of struct
    pos = init_ver2(pos);            //initialises ver2 part of struct
    pos = init_spike(pos);           //initialises spike part of struct

    init_counter1();                 //initialises counter1
    init_counter2();                 //initialises counter2

    return pos;
}


 //initializes data for horizontal moving platform 1
Pos Levels::init_hoz1(Pos pos)      
{
    pos.x = 0;      //x cord
    pos.y = 0;      //y cord
    pos.d = 0;      //dircection
    pos.c = 0;      //counter
    pos.l = 0;      //length
    pos.h = 0;      //height

    return pos;
}


//initializes data for horizontal moving platform 2
Pos Levels::init_hoz2(Pos pos)       
{
    pos.x2 = 0;     //x cord
    pos.y2 = 0;     //y cord
    pos.d2 = 0;     //dircection
    pos.c2 = 0;     //counter
    pos.l2 = 0;     //length
    pos.h2 = 0;     //height

    return pos;
}


//initializes data for vertical moving platform 1
Pos Levels::init_ver1(Pos pos)       
{
    pos.vx = 0;     //x cord
    pos.vy = 0;     //y cord
    pos.vd = 0;     //dircection
    pos.vc = 0;     //counter
    pos.vl = 0;     //length
    pos.vh = 0;     //height

    return pos;
}


//initializes data for vertical moving platform 1
Pos Levels::init_ver2(Pos pos)       
{
    pos.vx2 = 0;    //x cord
    pos.vy2 = 0;    //y cprd
    pos.vd2 = 0;    //dircection
    pos.vc2 = 0;    //counter
    pos.vl2 = 0;    //length
    pos.vh2 = 0;    //heighht

    return pos;
}


//initializes data for spikes
Pos Levels::init_spike(Pos pos)      
{
    pos.sx = 0;
    pos.sy = 0;
    pos.sl = 0;

    return pos;
}


//initializes counter 1
void Levels::init_counter1()         
{
    _counter1 = 0;

}


//initializes counter 2
void Levels::init_counter2()         
{
    _counter2 = 0;

}


//Creates a horizontal moving platform, and returns cordinates to pos struct
Pos Levels::moving_platform_hoz(N5110 &lcd, Pos pos, int x, int y, int w, int h, int dx, int s)  //x cord, y cord, width, hight, move too point, initial starting point.
{

    if (pos.c == 0) {                                       //sets counter to start point on first run,
        pos.c = s;                                          //pos.c never returns to 0, so it only happens when the level loads
    }

    if (pos.d == 0) {                                       //if direction is 0, move right
        pos.c++;
    } else {                                                //if direction is 1, move left
        pos.c--;
    }

    if (pos.c == dx || pos.c == 1 ) {                       //when moving platform meets dx (move to point) direction pivots,
        pos.d = !pos.d;                                     //same again, when moving platform reaches 1
    }

    pos.x = x + pos.c;                                      //pass x cord + counter to pos struct
    pos.y = y;                                              //pass y cord to pos struct
    pos.l = w;                                              //pass width to pos struct


    lcd.drawLine(pos.x, pos.y, pos.x + w, pos.y, 1);        //draw the moving platform using specified width and height parameters
    lcd.drawLine(pos.x, pos.y+h, pos.x + w, pos.y+h, 1);
    lcd.drawLine(pos.x, pos.y, pos.x, pos.y+h, 1);
    lcd.drawLine(pos.x+w, pos.y, pos.x +w, pos.y+h, 1);

    return pos;                                             //return pos (the position and state of the moving platform)
}


//Creates a vertical moving platform, and returns cordinates to pos struct
Pos Levels::moving_platform_ver(N5110 &lcd, Pos pos, int x, int y, int h, int w, int dx, int s)  //x cord, y cord, width, hight, move too point, initial starting point.
{
    if (pos.c == 0) {                                       //sets counter to start point on first run,
        pos.c = s;                                          //pos.c never returns to 0, so it only happens when the level loads
    }

    if (pos.d == 0) {                                       //if direction is 0, move down
        pos.c++;
    } else {                                                //if direction is 1, move up
        pos.c--;
    }

    if (pos.c == dx || pos.c == 1 ) {                       //when moving platform meets dx (move to point) direction pivots,
        pos.d = !pos.d;                                     //same again, when moving platform reaches 1
    }

    pos.x = x;                                              //pass x cord to pos struct
    pos.y = y + pos.c;                                      //pass y cord + counter to pos struct
    pos.l = w;                                              //pass width to pos struct
    pos.h = h;                                              //pass height to pos struct

    lcd.drawLine(pos.x, pos.y, pos.x, pos.y+h, 1);          //draw the moving platform using specified width and height parameters
    lcd.drawLine(pos.x, pos.y, pos.x+w, pos.y, 1);
    lcd.drawLine(pos.x+w, pos.y, pos.x+w, pos.y+h, 1);
    lcd.drawLine(pos.x, pos.y+h, pos.x+w, pos.y+h, 1);

    return pos;                                             //return pos (the position and state of the moving platform)
}


//print a singular spike at x, y
void Levels::spike_up(N5110 &lcd, int x, int y)          
{

    lcd.setPixel(x, y, true);
    lcd.setPixel(x+1, y-1, true);
    lcd.setPixel(x+1, y-2, true);
    lcd.setPixel(x+2, y, true);
}


//print a row of spikes of 'n' length, at x y
Pos Levels::spike_row_up(N5110 &lcd, Pos pos, int x, int y, int n) 
{

    for (int i = 0; i < n; i++) {                           //for n times,
        spike_up(lcd, x+i*2, y);                             //draw a spike
    }

    pos.sx = x;                                             //pass cordinatres to pos struct
    pos.sy = y;                                             //pass cordinates to pos struct
    pos.sl = n*2 +1;                                        //pass cordinates to pos struct

    return pos;
}


//depending on input, print following levels
Pos Levels::what_level(N5110 &lcd, int level)                
{
    switch (level) {
        case 0:
            _pos = level_zero(lcd);
            break;
        case 1:
            _pos = level_one(lcd);
            break;
        case 2:
            _pos = level_two(lcd);
            break;
        case 3:
            _pos = level_three(lcd);
            break;
        case 4:
            _pos = level_four(lcd);
            break;
        case 5:
            _pos = level_five(lcd);
            break;
        case 6:
            _pos = level_six(lcd);
            break;
        case 7:
            _pos = level_seven(lcd);
            break;
        case 8:
            _pos = level_eight(lcd);
            break;
        case 9:
            _pos = level_nine(lcd);
            break;
        case 10:
            _pos = level_ten(lcd);
            break;
        default:
            exit(1);
            break;
    }
    return _pos;
}


//transfer hoz1 into spare variables of original pos struct.
Pos Levels::pass_data_hoz1(Pos pos, Pos hoz)                  
{
    pos.x = hoz.x;
    pos.y = hoz.y;
    pos.d = hoz.d;
    pos.c = hoz.c;
    pos.l = hoz.l;
    pos.h = hoz.h;

    return pos;
}


//transfer hoz2 into spare variables of original pos struct.
Pos Levels::pass_data_hoz2(Pos pos, Pos hoz2)                 
{
    pos.x2 = hoz2.x;
    pos.y2 = hoz2.y;
    pos.d2 = hoz2.d;
    pos.c2 = hoz2.c;
    pos.l2 = hoz2.l;
    pos.h2 = hoz2.h;

    return pos;
}


//transfer ver into spare variables of original pos struct.
Pos Levels::pass_data_ver1(Pos pos, Pos ver)                  
{
    pos.vx = ver.x;
    pos.vy = ver.y;
    pos.vd = ver.d;
    pos.vc = ver.c;
    pos.vl = ver.l;
    pos.vh = ver.h;
    return pos;
}


//transfer ver2 into spare variables of original pos struct.
Pos Levels::pass_data_ver2(Pos pos, Pos ver2)                 
{
    pos.vx2 = ver2.x;
    pos.vy2 = ver2.y;
    pos.vd2 = ver2.d;
    pos.vc2 = ver2.c;
    pos.vl2 = ver2.l;
    pos.vh2 = ver2.h;

    return pos;
}



//increment counter1
void Levels::speech_counter1()                               
{
    _counter1++;
}


//inrement counter2
void Levels::speech_counter2()                               
{
    _counter2++;
}


//print string 'why hello there' word by word
void Levels::speech_one(N5110 &lcd)                          
{

    if (_counter1 > 5 && _counter1 < 15) {
        lcd.printString("  Why,",0,0);
    }

    if (_counter1 > 8 && _counter1 < 11) {
        lcd.printString(" Hello",0,1);
    }

    if (_counter1 > 10 && _counter1 < 16) {
        lcd.printString(" Hello there...",0,1);
    }

    if (_counter1 > 15 && _counter1 < 17) {
        lcd.printString("       there...",0,1);
    }
}


//print string 'you must be ' word by word
void Levels::speech_two(N5110 &lcd)                          
{
    if (_counter1 >= 20 && _counter1 < 22) {
        lcd.printString(" You ",0,0);
    }

    if (_counter1 >= 22 && _counter1 < 23) {
        lcd.printString(" You must ",0,0);
    }

    if (_counter1 >= 23 && _counter1 < 29) {
        lcd.printString(" You must be",0,0);
    }

    if (_counter1 >= 29 && _counter1 < 30) {
        lcd.printString("     must be",0,0);
    }

    if (_counter1 >= 30 && _counter1 < 31) {
        lcd.printString("          be",0,0);
    }

}


//print string 'the new guy' word by word
void Levels::speech_three(N5110 &lcd)                        
{
    if (_counter1 >= 24 && _counter1 < 25) {
        lcd.printString("  The ",0,1);
    }
    if (_counter1 >= 25 && _counter1 < 26) {
        lcd.printString("  The new",0,1);
    }
    if (_counter1 >= 26 && _counter1 < 32) {
        lcd.printString("  The new guy.,",0,1);
    }
    if (_counter1 >= 32 && _counter1 < 33) {
        lcd.printString("      new guy.,",0,1);
    }
    if (_counter1 >= 33 && _counter1 < 34) {
        lcd.printString("          guy.,",0,1);
    }
}


//print string 'use joy stick to move-go right' word by word
void Levels::speech_four(N5110 &lcd)                         
{
    if (_counter1 >= 40) {
        lcd.printString(" Use jystck to",0,0);
        lcd.printString("move-GO RIGHT!",0,1);
    }
}


//print string 'shame what' word by word
void Levels::speech_five(N5110 &lcd)                         
{

    if (_counter2 >= 5 && _counter2 < 6) {
        lcd.printString("   Shame ",0,0);
    }
    if (_counter2 >= 6 && _counter2 < 10) {
        lcd.printString("   Shame what",0,0);
    }
    if (_counter2 >= 10 && _counter2 < 11) {
        lcd.printString("         what",0,0);
    }
}


//print string 'happened to' word by word
void Levels::speech_six(N5110 &lcd)                          
{

    if (_counter2 >= 7 && _counter2 < 8) {
        lcd.printString(" happened ",0,1);
    }
    if (_counter2 >= 8 && _counter2 < 12) {
        lcd.printString(" happened to ",0,1);
    }
    if (_counter2 >= 12 && _counter2 < 13) {
        lcd.printString("          to ",0,1);
    }
}


//print string 'the last lad...' word by word
void Levels::speech_seven(N5110 &lcd)                        
{

    if (_counter2 >= 13 && _counter2 < 14) {
        lcd.printString("   the ",0,0);
    }
    if (_counter2 >= 14 && _counter2 < 20) {
        lcd.printString("   the last",0,0);
    }
    if (_counter2 >= 20 && _counter2 < 21) {
        lcd.printString("       last",0,0);
    }

    if (_counter2 >= 16 && _counter2 < 23) {
        lcd.printString("  lad...",0,1);
    }
}


//print string 'press button a to jump' word by word
void Levels::speech_eight(N5110 &lcd)                        
{
    if (_counter2 >= 26) {
        lcd.printString(" Press button",0,0);
        lcd.printString(" A to jump",0,1);
    }
}


//print string 'I was just' word by word
void Levels::speech_nine(N5110 &lcd)                         
{

    if (_counter1 >= 5 && _counter1 < 6) {
        lcd.printString(" I ",0,0);
    }
    if (_counter1 >= 6 && _counter1 < 7) {
        lcd.printString(" I was",0,0);
    }
    if (_counter1 >= 7 && _counter1 < 10) {
        lcd.printString(" I was just",0,0);
    }
    if (_counter1 >= 10 && _counter1 < 11) {
        lcd.printString("   was just",0,0);
    }
    if (_counter1 >= 11 && _counter1 < 12) {
        lcd.printString("       just",0,0);
    }
}


//print string 'starting to' word by word
void Levels::speech_ten(N5110 &lcd)                          
{

    if (_counter1 >= 8 && _counter1 < 13) {
        lcd.printString("starting ",0,1);
    }
    if (_counter1 >= 9 && _counter1 < 14) {
        lcd.printString("starting to ",0,1);
    }
    if (_counter1 >= 14 && _counter1 < 15) {
        lcd.printString("         to",0,1);
    }
}


//print string 'like him' word by word
void Levels::speech_elleven(N5110 &lcd)                      
{

    if (_counter1 >= 14 && _counter1 < 15) {
        lcd.printString("   like ",0,0);
    }
    if (_counter1 >= 15 && _counter1 < 25) {
        lcd.printString("   like him",0,0);
    }
    if (_counter1 >= 25 && _counter1 < 26) {
        lcd.printString("        him",0,0);
    }
}


//print string 'as well!' word by word
void Levels::speech_twelve(N5110 &lcd)                       
{

    if (_counter1 >= 16 && _counter1 < 17) {
        lcd.printString(" as  ",0,1);
    }
    if (_counter1 >= 17 && _counter1 < 27) {
        lcd.printString(" as well!  ",0,1);
    }
    if (_counter1 >= 27 && _counter1 < 28) {
        lcd.printString("    well! ",0,1);
    }
}


//print string 'Here's an idea..' word by word
void Levels::speech_thirteen(N5110 &lcd)                     
{
    if (_counter2 >= 5 && _counter2 < 12) {
        lcd.printString("Here's", 55, 3);
    }
    if (_counter2 >= 6 && _counter2 < 13) {
        lcd.printString("an", 42, 4);
    }
    if (_counter2 >= 7 && _counter2 < 14) {
        lcd.printString("idea..", 45, 5);
    }
}


//print string 'try a wall jump' word by word
void Levels::speech_forteen(N5110 &lcd)                      
{
    if (_counter2 >= 13 && _counter2 < 22) {
        lcd.printString("try", 60, 3);
    }
    if (_counter2 >= 14 && _counter2 < 23) {
        lcd.printString("a", 45, 4);
    }
    if (_counter2 >= 14 && _counter2 < 23) {
        lcd.printString("a wall", 45, 4);
    }
    if (_counter2 >= 14 && _counter2 < 23) {
        lcd.printString("a wall", 45, 4);
    }
    if (_counter2 >= 16 && _counter2 < 25) {
        lcd.printString("jump!", 50, 5);
    }
}


//run level one
Pos Levels::level_one(N5110 &lcd)                            
{

    lcd.drawLine(0,40,84,40,1);                             //draw lines for level

    speech_level_one(lcd);                                    //display speech for level

    _pos = init_hoz1(_pos);                                  //intialise all variables not being used in level
    
    return _pos;                                            //return postions of moving platforms if any.

}


//run level one speech
void Levels::speech_level_one(N5110 &lcd)                     
{
    speech_counter1();                                       //counter increments
    speech_one(lcd);                                         //speech appears according to counter
    speech_two(lcd);
    speech_three(lcd);
    speech_four(lcd);
}

Pos Levels::init_level_one(Pos pos) 
{
    _pos = init_hoz1(_pos);                                  //intialise all variables not being used in level
    _pos = init_hoz2(_pos);
    _pos = init_ver1(_pos);
    _pos = init_ver2(_pos);
    _pos = init_spike(_pos);
    init_counter2();
    
    return _pos;
}

//run level two
Pos Levels::level_two(N5110 &lcd)                            
{


    lcd.drawLine(0,40,35,40,1);                             //draw lines for level
    lcd.drawLine(35,40,35,48,1);
    lcd.drawLine(50,40,84,40,1);
    lcd.drawLine(50,40,50,48,1);

    speech_level_two(lcd);                                    //display speech for level

    _pos = init_level_two(_pos);

    return _pos;                                            //return postions of moving platforms if any.
}


//intialises all platform variables not being used in level 2
Pos Levels::init_level_two(Pos pos) 
{
    _pos = init_hoz1(_pos);                         //intialise all variables not being used in level
    _pos = init_hoz2(_pos);
    _pos = init_ver1(_pos);
    _pos = init_ver2(_pos);
    _pos = init_spike(_pos);
    init_counter1();
    
    return _pos;
}


//run level two speech
void Levels::speech_level_two(N5110 &lcd)                     
{
    speech_counter2();                                       //counter increments
    speech_five(lcd);                                        //speech appears according to counter
    speech_six(lcd);
    speech_seven(lcd);
    speech_eight(lcd);
}


//run level three
Pos Levels::level_three(N5110 &lcd)                          
{
    lcd.drawLine(0,40,15,40,1);                             //draw lines for level
    lcd.drawLine(15,40,15,48,1);
    lcd.drawLine(70,40,84,40,1);
    lcd.drawLine(70,40,70,48,1);

    lcd.drawLine(74,14,74,0,1);
    lcd.drawLine(74,14,84,14,1);

    _hoz1 = moving_platform_hoz(lcd, _hoz1, 25, 40, 10, 3, 25, 1);    //set parameters for horizontal moving platform
    _pos = pass_data_hoz1(_pos, _hoz1);

    speech_level_three(lcd);                                  //display speech for level

    _pos = init_level_three(_pos);

    return _pos;
}


//intialises all platform variables not being used in level 3
Pos Levels::init_level_three(Pos pos) 
{
                                  //intialise all variables not being used in level
    _pos = init_hoz2(_pos);
    _pos = init_ver1(_pos);
    _pos = init_ver2(_pos);
    _pos = init_spike(_pos);
    init_counter2();
    
    return _pos;
}


//run level three speech
void Levels::speech_level_three(N5110 &lcd)                   
{
    speech_counter1();                                       //counter increments
    speech_nine(lcd);                                        //speech appears according to counter
    speech_ten(lcd);
    speech_elleven(lcd);
    speech_twelve(lcd);
}


//run level four
Pos Levels::level_four(N5110 &lcd)                           
{

    lcd.drawLine(0,40,84,40,1);                             //draw lines for level
    lcd.drawLine(0,14,10,14,1);
    lcd.drawLine(10,0,10,14,1);

    lcd.drawLine(74,14,74,0,1);
    lcd.drawLine(74,14,84,14,1);

    _ver1 = moving_platform_ver(lcd, _ver1, 11, 0, 18, 30, 21, 10);   //set parameters for vertical moving platform
    _pos = pass_data_ver1(_pos, _ver1);
    _ver2 = moving_platform_ver(lcd, _ver2, 42, 0, 18, 31, 21, 1);    //set parameters for vertical 2 moving platform
    _pos = pass_data_ver2(_pos, _ver2);
    
    _pos = init_level_four(_pos);
    
    return _pos;


}


//intialises all platform variables not being used in level 4
Pos Levels::init_level_four(Pos pos) 
{
    _pos = init_hoz1(_pos);                                  //intialise all variables not being used in level
    _pos = init_hoz2(_pos);
    _pos = init_spike(_pos);
    init_counter2();
    init_counter1();
    
    return _pos;
}


//run level five
Pos Levels::level_five(N5110 &lcd)                           
{

    lcd.drawLine(0,40,40,40,1);                             //draw lines for level
    lcd.drawLine(40,40,40,20,1);
    lcd.drawLine(40,20,84,20,1);

    lcd.drawLine(0,14,10,14,1);
    lcd.drawLine(10,14,10,25,1);
    lcd.drawLine(10,25,20,25,1);
    lcd.drawLine(20,0,20,25,1);

    speech_counter2();                                       //run speech for level
    speech_thirteen(lcd);
    speech_forteen(lcd);

    _pos = spike_row_up(lcd, _pos, 55, 19, 5);                //set parameters for spikes

    _pos = init_level_five(_pos);

    return _pos;

}



//intialises all platform variables not being used in level 4
Pos Levels::init_level_five(Pos pos) 
{
    _pos = init_hoz1(_pos);                              //intialise all variables not being used in level
    _pos = init_hoz2(_pos);
    _pos = init_ver1(_pos);
    _pos = init_ver2(_pos);
    init_counter1();
    
    return _pos;
}


//run level six
Pos Levels::level_six(N5110 &lcd)                            
{

    lcd.drawLine(0,20,10,20,1);                             //draw lines for level
    lcd.drawLine(10,20,10,48,1);                            
    lcd.drawLine(74,48,74,20,1);
    lcd.drawLine(74,20,84,20,1);

    _ver1 = moving_platform_ver(lcd, _ver1, 23, 10, 3, 5, 20, 1);     //set parameters for vertical moving platform
    _pos = pass_data_ver1(_pos, _ver1);

    _ver2 = moving_platform_ver(lcd, _ver2, 56, 10, 3, 5, 20, 19);    //set parameters for vertical 2 moving platform
    _pos = pass_data_ver2(_pos, _ver2);

    _pos = init_level_six(_pos);

    return _pos;
}




//intialises all platform variables not being used in level 6
Pos Levels::init_level_six(Pos pos) 
{
    _pos = init_hoz1(_pos);                                  //intialise all variables not being used in level
    _pos = init_hoz2(_pos);
    init_counter2();
    init_counter1();
    _pos = init_spike(_pos);
    
    return _pos;
}


//run level seven
Pos Levels::level_seven(N5110 &lcd)                          
{   
    lcd.drawLine(0,20,10,20,1);                             //draw lines for level
    lcd.drawLine(10,20,10,48,1);

    lcd.drawLine(50,39,56,39,1);
    lcd.drawLine(50,39,50,37,1);
    lcd.drawLine(56,37,56,39,1);

    lcd.drawLine(70,40,84,40,1);
    lcd.drawLine(70,40,70,48,1);

    _hoz1 = moving_platform_hoz(lcd, _hoz1, 20, 40, 20, 3, 25, 1);     //set parameters for horizontal moving platform   
    _pos = pass_data_hoz1(_pos, _hoz1);

    _pos = spike_row_up(lcd, _pos, 50, 37, 3);                //set parameters for spikes

    _pos = init_level_seven(_pos);                                  //intialise all variables not being used in level


    return _pos;
}


//intialises all platform variables not being used in level 7
Pos Levels::init_level_seven(Pos pos) 
{
    _pos = init_hoz2(_pos);
    _pos = init_ver1(_pos);
    _pos = init_ver2(_pos);
    init_counter2();
    
    return _pos;
}


//run level eight
Pos Levels::level_eight(N5110 &lcd)                      
{

    lcd.drawLine(0,40,10,40,1);                         //draw lines for level
    lcd.drawLine(10,40,10,48,1);

    lcd.drawLine(22,48,22,32,1);
    lcd.drawLine(62,48,62,32,1);
    lcd.drawLine(22,32,62,32,1);

    lcd.drawLine(74,10,84,10,1);
    lcd.drawLine(74,10,74,48,1);


    _ver1 = moving_platform_ver(lcd, _ver1, 11, 10, 40, 10, 25, 1);       //set parameters for vertical moving platform  
    _pos = pass_data_ver1(_pos, _ver1);
    _ver2 = moving_platform_ver(lcd, _ver2, 63, 15, 40, 10, 25, 24);      //set parameters for vertical moving platform  2
    _pos = pass_data_ver2(_pos, _ver2);

    _pos = spike_row_up(lcd, _pos, 24, 31, 18);                             //set parameters for spikes
    
    _pos = init_level_eight(_pos);
    
    return _pos;
}


//intialises all platform variables not being used in level 8
Pos Levels::init_level_eight(Pos pos) 
{
    _pos = init_hoz1(_pos);                                  //intialise all variables not being used in level
    _pos = init_hoz2(_pos);
    init_counter2();
    
    return _pos;
}


//run level nine
Pos Levels::level_nine(N5110 &lcd)
{
    
    lcd.drawLine(0,10,25,10,1);
    lcd.drawLine(25,12,25,10,1);
    lcd.drawLine(25,12,5,12,1);
    lcd.drawLine(5,12,5,48,1);
    
    lcd.drawLine(45,0,45,25,1);
    lcd.drawLine(45,25,20,25,1);
    lcd.drawLine(20,25,20,28,1);
    lcd.drawLine(20,28,55,28,1);
    lcd.drawLine(55,28,65,0,1);
    
    
    lcd.drawLine(30,46,70,46,1);
    lcd.drawLine(70,46,70,40,1);
    lcd.drawLine(70,40,84,40,1);
    lcd.drawLine(30,46,30,48,1);
   
    _pos = init(_pos);
    
    return _pos;
}



//run level ten
Pos Levels::level_ten(N5110 &lcd)
{
    
    _pos = init(_pos);
    
    lcd.drawLine(0,40,70,40,1);
    lcd.drawLine(70,40,70,0,1);
    
    lcd.printString(" ..the end,", 0, 0);
    lcd.printString("now what??", 0, 1);
    return _pos;
}


//run level zero
Pos Levels::level_zero(N5110 &lcd)
{
    lcd.printString("  I said the  ", 0, 0);
    lcd.printString("   other Way..  ", 0, 1);
    lcd.drawLine(84,40,10,40,1);
    lcd.drawLine(10,40,10,0,1);
    
    
    return _pos;
}
