#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "BlockheadEngine.h"

//nothing needed doing in constructor or deconstructor 
BlockheadEngine::BlockheadEngine()
{

}

BlockheadEngine::~BlockheadEngine()
{

}


//intialise all variables for new game
void BlockheadEngine::init()                                        
{
    _blockhead.init();                                              //intialise variables in blockhead class
    _pos = _lev.init(_pos);                                         //intialise variables in level class and _pos struct
    

}


//intialise all variables for continue game 
void BlockheadEngine::continue_init()                                
{
    _blockhead.continue_init();                                     //level not intialised and x/y cordinate of blockhead differs dpending on what level you are on
    _pos = _lev.init(_pos);                                         //initialise variables in level class and _pos struct
    

}


//runs the game 'blockhead'
int BlockheadEngine::playgame(N5110 &lcd, Gamepad &pad)             
{
    lcd.clear();                                                    //clear lcd first
    
    _level = _blockhead.next_level();                               //returns what level blockhead is on
    _pos = _lev.what_level(lcd, _level);                             //displays that level on lcd, as well as passes cordinates of moving platforms and spikes to _pos structs
    _blockhead.blockhead(_pos, lcd, pad);                           //controlls blcokhead depending on position in game,
    _gameover = _blockhead.gameover_flag(pad);                      //_gameover = 1 once blockhead dies
    
    lcd.refresh();                                                  //updates screen

    return _gameover;                                               //returns _gameover
}


//returns highscore (the highest level reached by user)
int BlockheadEngine::highscore()
{   
    if (_level >= _highscore) {                                     //if level reached is higher than current highscore
        _highscore = _level;                                        //then _highscore = _level
    }

    return _highscore;                                              //returns _highscore
}

