#ifndef LEVELS_H
#define LEVELS_H

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
/** Pos struct for position of moving platforms and spikes*/
struct Pos { 
//////////hoz1//////////
    int x;          /**< x cord of hoz1  */
    int y;          /**< y cord of hoz1 */
    int d;          /**< direction of hoz1 (0 is right, 1 is left) */
    int c;          /**< counter for hoz1 */      
    int l;          /**< length of hoz1 */
    int h;          /**< height of hoz1 */
//////////hoz2//////////
    int x2;         /**< x cord of hoz2 */
    int y2;         /**< y cord of hoz2 */
    int d2;         /**< direction of hoz2   (0 is right, 1 is left) */
    int c2;         /**< counter for hoz2 */
    int l2;         /**< length of hoz2 */
    int h2;         /**< length of hoz2 */
//////////ver1//////////
    int vx;         /**< x cord of ver1 */
    int vy;         /**< y cord of ver1 */
    int vd;         /**< direction of ver 1 (0 is down, 1 is up) */
    int vc;         /**< counter for ver1 */
    int vl;         /**< length of ver1 */
    int vh;         /**< height of ver1 */
//////////ver2//////////
    int vx2;        /**< x cord of ver2 */
    int vy2;        /**< y cord of ver2 */
    int vd2;        /**< direction of ver2 (0 is down, 1 is up) */
    int vc2;        /**< counter for ver2 */
    int vl2;        /**< length of ver2 */
    int vh2;        /**< height of ver2 */
//////////spikes//////////
    int sx;         /**< x cord of spikes */
    int sy;         /**< y cord of spikes */
    int sl;         /**< length of spikes */

};


/** Levels Class
 * @brief Class for creating and printing levels
 * @author Adam P. Baker
 * @date 9 May 2019
 */
class Levels
{
public:
    /** Constructor */
    Levels();
    
    /** Deconstructor */
    ~Levels();
    
    /** Initialises all variables and pos struct.
    *@returns pos struct 
    */
    Pos init(Pos pos);
    
    /** Displays the level Blockhead is on
    *@param N5110 class which controlls lcd screen
    *@param what level Blockhead is on (int)
    *@returns pos struct
    */
    Pos what_level(N5110 &lcd, int level);

private:

    Pos init_hoz1(Pos pos);                              //initializes data for horizontal moving platform 1
    Pos init_hoz2(Pos pos);                              //initializes data for horizontal moving platform 2
    Pos init_ver1(Pos pos);                              //initializes data for vertical moving platform 1
    Pos init_ver2(Pos pos);                              //initializes data for vertical moving platform 2
    Pos init_spike(Pos pos);                             //initializes data for spikes
    void init_counter1();                                //initializes counter 1
    void init_counter2();                                //initializes counter 2

    Pos pass_data_hoz1(Pos pos, Pos hoz);                 //transfer hoz1 into spare variables of original pos struct.
    Pos pass_data_hoz2(Pos pos, Pos hoz2);                //transfer hoz2 into spare variables of original pos struct.
    Pos pass_data_ver1(Pos pos, Pos ver);                 //transfer ver into spare variables of original pos struct.
    Pos pass_data_ver2(Pos pos, Pos ver2);                //transfer ver2 into spare variables of original pos struct.
    
    Pos moving_platform_hoz(N5110 &lcd, Pos pos, int x, int y, int w, int h, int dx, int s);  //creates a moving platform depending on perameters
    Pos moving_platform_ver(N5110 &lcd, Pos pos, int x, int y, int h, int w, int dx, int s);  //creates a moving platform depending on perameters
    void spike_up(N5110 &lcd, int x, int y);                         //creates a singular spike
    Pos spike_row_up(N5110 &lcd, Pos pos, int x, int y, int n);       //creates a row of spikes of n length
    
    void speech_counter1();              //increment counter1
    void speech_counter2();              //inrement counter2
    void speech_one(N5110 &lcd);         //print string 'why hello there' word by word     
    void speech_two(N5110 &lcd);         //print string 'you must be ' word by word
    void speech_three(N5110 &lcd);       //print string 'the new guy' word by word
    void speech_four(N5110 &lcd);        //print string 'use joy stick to move-go right' word by word      
    void speech_five(N5110 &lcd);        //print string 'shame what' word by word
    void speech_six(N5110 &lcd);         //print string 'happened to' word by word
    void speech_seven(N5110 &lcd);       //print string 'the last lad...' word by word               
    void speech_eight(N5110 &lcd);       //print string 'press button a to jump' word by word
    void speech_nine(N5110 &lcd);        //print string 'I was just' word by word
    void speech_ten(N5110 &lcd);         //print string 'starting to' word by word
    void speech_elleven(N5110 &lcd);     //print string 'like him' word by word
    void speech_twelve(N5110 &lcd);      //print string 'as well!' word by word
    void speech_thirteen(N5110 &lcd);    //print string 'Here's an idea..' word by word
    void speech_forteen(N5110 &lcd);     //print string 'try a wall jump' word by word
    
    Pos level_one(N5110 &lcd);           //prints level one
    Pos init_level_one(Pos pos); 
    void speech_level_one(N5110 &lcd);
    
    Pos level_two(N5110 &lcd);           //prints level two
    void speech_level_two(N5110 &lcd);
    Pos init_level_two(Pos pos); 
    
    Pos level_three(N5110 &lcd);         //prints level three
    void speech_level_three(N5110 &lcd);
    Pos init_level_three(Pos pos); 
    
    Pos level_four(N5110 &lcd);          //prints level four
    Pos init_level_four(Pos pos);
    
    Pos level_five(N5110 &lcd);          //prints level five
    Pos init_level_five(Pos pos);
    
    Pos level_six(N5110 &lcd);           //prints level six
    Pos init_level_six(Pos pos);
    
    Pos level_seven(N5110 &lcd);         //prints level seven
    Pos init_level_seven(Pos pos);
    
    Pos level_eight(N5110 &lcd);         //prints level eight
    Pos init_level_eight(Pos pos);
    
    Pos level_nine(N5110 &lcd);          //prints level nine
    Pos init_level_nine(Pos pos);
     
    Pos level_ten(N5110 &lcd);           //prints level ten

    Pos level_zero(N5110 &lcd);          //prints level ten
    
    Pos _pos;  //struct containing position and direction of moving platforms
    Pos _hoz1;
    Pos _hoz2;
    Pos _ver1;
    Pos _ver2;
    
    int _counter1; //counters for displaying speech
    int _counter2;
};

#endif