#ifndef BLOCKHEADENGINE_H
#define BLOCKHEADENGINE_H

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Blockhead.h"
#include "Levels.h"
#include "Animation.h"

/** BlockheadEngine Class
 * @brief Class for running the game
 * @author Adam P. Baker
 * @date 9 May 2019
 */
class BlockheadEngine
{
public:
    /** Constructor */
    BlockheadEngine();
    
    /** Deconstructor */
    ~BlockheadEngine();
    
    /** Initialises variables in blockhead class and level class and _pos struct. */
    void init();
    
    /** Intialises variables in blockhead class and level class and _pos struck (except level number which it keeps the same) */
    void continue_init();
    
    /** runs the game 'blockhead'
    *@param N5110 class which controlls lcd screen
    *@param Gamepad class for working with the gamepad 
    *@returns _gameover (0 when blockhead alive, 1 once died) (int)
    */
    int playgame(N5110 &lcd, Gamepad &pad);
    
    /** sets highscore if new highest level reached
    *@returns _highscore (int)
    */
    int highscore();
    
private:

    Blockhead _blockhead;       //blockhead class 
    Levels _lev;                //levels class 
    
    Pos _pos;                   //_pos struct 


    int _gameover;              /**< _gameover flag (0 when alive, 1 onnce died) */
    int _level;                 /**< what level blockhead is on */
    int _highscore;             /**< highest level reached */
};

#endif