#ifndef RUNNER_H
#define RUNNER_H

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Levels.h"
#include "Animation.h"


/** Blockhead Class
 * @brief Class for controlling the main mechanics of the Blockhead character
 * @author Adam P. Baker
 * @date 9 May 2019
 */
class Blockhead
{
public:
    /** Constructor */
    Blockhead();

    /** Deconstructor */
    ~Blockhead();

    /** initialises all variables for new game */
    void init();

    /** initialises variables for continue game (does not intialise level) */
    void continue_init();

    /** changes level when character reaches side of screen
    *@returns level blockhead is on (int)
    */
    int next_level();

    /** controlls blockhead depending on position in game, and user input
    *@param pos struct which contains cordinates and direction of moving platforms
    *@param N5110 class which controlls lcd screen
    *@param Gamepad class for working with the gamepad
    */
    void blockhead(Pos pos, N5110 &lcd, Gamepad &pad);

    /** retruns 1 when gameover occurs
    *@param Gamepad class for working with the gamepad 
    *@returns gameover (0 when alive, 1 once died) (int)
    */
    int gameover_flag(Gamepad &pad);


private:

    void movement(N5110 &lcd, Gamepad &pad);                        //controlls movement of blockhead
    void gameover(Pos pos, N5110 &lcd);                             //starts death sequence is spike hit or platform crush
    
    float get_speed(Gamepad &pad);                                  //changes speed depending on joystick position
    void button_press(N5110 &lcd, Gamepad &pad);                    //intiates jump/wj if button pressed at correct time
    void jump(N5110 &lcd);                                          //peformes jump if right condtions met
    void wall_jump_right(N5110 &lcd, float speed);                  //peformes wall jump right if right conditions met
    void wall_jump_left(N5110 &lcd, float speed);                   //peformes wall jump left if right conditions met
    void fall(N5110 &lcd);                                          //falls if right condistions met
    void run_right(N5110 &lcd, float speed);                        //runs right at certain speed depenign on speed variable 
    void run_left(N5110 &lcd, float speed);                         //runs left at certain speed depenign on speed variable 
    void cancel_sprint(N5110 &lcd, float speed);                    //cancels sprint if obstical hit

    void move_up(N5110  &lcd, int n);                               //moves blockhead n pixels up
    void move_down(N5110 &lcd, int n);                              //moves blockhead n pixels down
    void move_right(N5110 &lcd, int n);                             //moves blockhead n pixels right
    void move_left(N5110 &lcd, int n);                              //moves blockhead n pixels left
    
    void runner_state(N5110 &lcd, Gamepad &pad, float _speed);      //what animation displayed depending if alive or died
    void alive_sequence(N5110 &lcd, float _speed);                  //what animations displayed when alive
    void run_sequence_right(N5110 &lcd);                            //peforms running right animation
    void run_sequence_left(N5110 &lcd);                             //peforms running left animation
    void walk_sequence_right(N5110 &lcd);                           //peforms walking right animation
    void walk_sequence_left(N5110 &lcd);                            //performes walking left animation
    void death_sequence(N5110 &lcd, Gamepad &pad);                  //peformes death animation

    int on_hoz_check(Pos pos);                                      //checks if on horizontal (hoz) platfrom
    int by_hoz_check_right(Pos pos);                                //checks if by hoz plat right
    int by_hoz_check_left(Pos pos);                                 //checks if by hoz plat left
    int on_hoz_2_check(Pos pos);                                    //checks if by hoz plat 2
    int by_hoz_2_check_right(Pos pos);                              //checks if by hoz plat right 2
    int by_hoz_2_check_left(Pos pos);                               //checks if by hoz plat left 2
    int on_ver_check(Pos pos);                                      //checks if on vertical platform
    int on_ver_2_check(Pos pos);                                    //checks if on vertical platform 2
                                   
    void platform_check(Pos pos);                                   //checks if on platforms,
    void on_platform(N5110 &lcd);                                   //moves blockhead accordingly if so
    
    int crushed_by_ver(Pos pos);                                    //returns one if crushed by platform
    int crushed_by_ver_2(Pos pos);                                  //returns one if crushed by platform 2
    int spike_hit(N5110 &lcd, Pos pos);                             //returns one if spike is hit
    int fallen(Gamepad &pad);                                       //returns one if fallen off screen

    void fall_tune(Gamepad &pad);                                   //plays tune when fallen off screen

    Animation _ani;                                                 //animation class

    float _speed;                                                   //speed of blockhead
    int _gameover;                                                  //gameover flag (0 when alive, 1 once died)

    int _x;             /**< x cord of blockhead */
    int _y;             /**< y cord of blockhead */
    int _jump;          /**< jump counter */
    int _wjr;           /**< wall jump right counter */
    int _wjl;           /**< wall jump left counter */
    int _fall;          /**< fall counter */
    int _sprintright;   /**< sprint left counter */
    int _sprintleft;    /**< sprint right counter */
    int _level;         /**< what level */
    int _runani;        /**< run animation counter */
    int _walkani;       /**< walk animation counter */
    int _death;         /**< death counter */

    int _d;             /**< direction of horizontal moving platform one */
    int _r;             /**< by the right of horizontal moving platform one */
    int _l;             /**< by the left of horizontal moving platform one */
    int _d2;            /**< direction of horizontal moving platform two */
    int _r2;            /**< by the right of horizontal moving platform two */
    int _l2;            /**< by the left of horizontal moving platform two */
    int _d3;            /**< direction of vertical moving platform one */
    int _d4;            /**< direction of vertical moving platform one */

};

#endif