#include "Tetromino.h"
#include "Graphics.h"

Tetromino::~Tetromino() {}

Tetromino Tetromino::teleportedTo(int x) {
    return translated(x, 0);
}

Tetromino Tetromino::getTetrominoOfType(Tetromino::Type type) {
    switch (type) {
        case Tetromino::I:
            return Tetromino::getTetrominoFromString(
                "* "
                "* "
                "* "
                "* ");
        case Tetromino::O:
            return Tetromino::getTetrominoFromString(
                "**"
                "**""  ""  ");
        case Tetromino::T:
            return Tetromino::getTetrominoFromString(
                "* "
                "**"
                "* ""  ");
        case Tetromino::J:
            return Tetromino::getTetrominoFromString(
                " *"
                " *"
                "**""  ");
        case Tetromino::L:
            return Tetromino::getTetrominoFromString(
                "* "
                "* "
                "**""  ");
        case Tetromino::S:
            return Tetromino::getTetrominoFromString(
                " *"
                "**"
                "* ""  ");
        case Tetromino::Z:
            return Tetromino::getTetrominoFromString(
                "*"
                "**"
                " *""  ");
        default:
            return Tetromino::getTetrominoFromString(
                " *"
                "* "
                " *"
                "* ");
    }
}

Tetromino Tetromino::getTetrominoFromString(const char * str_blocks) {
    int top = 0;
    Block blocks[4];
    for (int i = 0; i < 8; i++) {
        if (str_blocks[i] == '*') {
            blocks[top] = Block(i % 2, i / 2);
            top++;
        }
    }
    return Tetromino(blocks[0], blocks[1], blocks[2], blocks[3]);
}

Tetromino::Tetromino(Block a, Block b, Block c, Block d) {
    blocks[0] = a;
    blocks[1] = b;
    blocks[2] = c;
    blocks[3] = d;
}

Tetromino Tetromino::translated(int dx, int dy) {
    return Tetromino(
        blocks[0].translated(dx, dy),
        blocks[1].translated(dx, dy),
        blocks[2].translated(dx, dy),
        blocks[3].translated(dx, dy)
    );
}

Tetromino Tetromino::movedDown() {
    return translated(0, 1);
}

Tetromino Tetromino::movedLeft() {
    return translated(-1, 0);
}

Tetromino Tetromino::movedRight() {
    return translated(1, 0);
}

Tetromino Tetromino::rotatedClockwise() {
    // get average x
    int average_x = 0;
    for (int i = 0; i < 4; i++) {
        average_x += blocks[i].getX();
    }
    average_x = (average_x + 1) / 4;
    
    // get average y
    int average_y = 0;
    for (int i = 0; i < 4; i++) {
        average_y += blocks[i].getY();
    }
    average_y = (average_y + 1) / 4;
    
    return Tetromino(
        blocks[0].rotateAround(average_x, average_y),
        blocks[1].rotateAround(average_x, average_y),
        blocks[2].rotateAround(average_x, average_y),
        blocks[3].rotateAround(average_x, average_y)
    );
}

Tetromino Tetromino::rotatedAnticlockwise() {
    // a triple clockwise rotation <=> an anticlockwise rotation
    return rotatedClockwise().rotatedClockwise().rotatedClockwise();
}

void Tetromino::draw() {
    for (int i = 0; i < 4; i++) {
        int x = blocks[i].getX();
        int y = blocks[i].getY();
        Graphics::Game::drawBlock(x, y);
    }
}

Tetromino::Type Tetromino::getRandomTetrominoType() {
    return Tetromino::Type(rand() % Z);
}