#include "MainMenu.h"

#include "DifficultyMenu.h"
#include "ControlsMenu.h"
#include "OptionsMenu.h"
#include "ScoresMenu.h"
#include "MenuManager.h"

void Menus::MainMenu::close()  {
    // override to do nothing
    // main menu shouldn't get closed
}

void Menus::MainMenu::updateAndDraw(UI * ui) {
    ui->drawLogo();
    ui->newLine();
    if (ui->drawAndCheckButton("play")) {
        MenuManager::add(new DifficultyMenu());
    }
    if (ui->drawAndCheckButton("controls")) {
        MenuManager::add(new ControlsMenu());
    }
    if (ui->drawAndCheckButton("options")) {
        MenuManager::add(new OptionsMenu());
    }
    if (ui->drawAndCheckButton("scores")) {
        MenuManager::add(new ScoresMenu());
    }
    ui->newLine();
    ui->drawLabel("by angus");
    ui->drawLabel(" findlay");
}