#include "Menu.h"

namespace Menus {
    /**
     * Game Over Menu class
     * @brief Subclasses Menu, overriding updateAndDraw to make a menu
     * designed to appear when the game finishes
     */
    class GameOverMenu : public Menu {
    public:
        /**
         * @brief Constructor to load the score and player data
         * into character buffers.
         */
        GameOverMenu();
        
        /**
         * @brief Draws the game over screen, with player number and score, 
         * as well as the option to look at the leaderboard. If a top 3 score 
         * is achived, flashing text appears.
         */
        virtual void updateAndDraw(UI * ui);
        
        /**
         * @brief The inherited close method is overriden to make sure the
         * user cannot pop this menu off the stack and simply return 
         * to gameplay.
         */
        virtual void close();
    private:
        char number_text[10];
        char score_text[10];
        bool new_high_score;
        
        /**
         * True if the SD card is working
         */
        bool sd_working;
    };
};