#include "Math.h"

int Math::lerp(int a, int b) {
    return lerp(a, b, 0.6);
}

int Math::lerp(int a, int b, double t) {
    if (a < b) {
        int lerped = (a * (1 - t)) + (b * t) + 0.5;
        if (lerped > a + 1) {
            return lerped;
        } else if (a + 1 <= b) {
            return a + 1;
        } else {
            return b;
        }
    } else {
        int lerped = (a * (1 - t)) + (b * t);
        if (lerped < a - 1) {
            return lerped;
        } else if (a - 1 >= b) {
            return a - 1;
        } else {
            return b;
        }
    }
}