#include "Engine.h"

#include "Graphics.h"
#include "MenuManager.h"
#include "MainMenu.h"
#include "Input.h"

namespace Engine {

    Game * game;
    
    void init() {
        Graphics::init();
        Menus::MainMenu * menu = new Menus::MainMenu();
        Menus::MenuManager::add(menu);
        // seed random number generator with analog in
        srand(Input::getSeed());
    }
    
    void deinit() {
        Graphics::deinit();
        delete game;
    }

    void loop() {
        while (true) {
            Graphics::clear();
            
            if (Menus::MenuManager::count() == 0) {
                if (game != NULL) {
                    game->update();
                    game->draw();
                }
            } else {
                Menus::MenuManager::updateAndDraw();
            }
            
            Graphics::render();
            wait_ms(1000 / Engine::FPS);
        }
    }
        
    void startGame(Game::Difficulty difficulty) {
        game = new Game(difficulty);
    }
};
