/**
 * Unit Tests class
 * @brief Runs a series of unit tests, printing the restults to stdout
 */
class UnitTests {
public:
    /**
     * @brief Runs all unit tests, and prints their name
     */
    static void runAllTests();
private:
    /**
     * @brief 
     * @param description A description of the test to print if it fails
     * @param result The result of the test, if it's false the error will print
     */
    static void assertTrue(const char * description, bool result);
    
    /**
     * @brief Test the tetromino is the same after being rotated 360 degrees
     */
    static void testTetromino();
    
    /**
     * @brief Test the blocks are instanciated correctly
     */
    static void testBlock();
    
    /**
     * @brief Tests that preferences are saved and retrived correctly
     */
    static void testPrefs();
    
    /**
     * @brief Test that the space is taken up when a tetromino 
     * is inserted into the grid
     */
    static void testGrid();
};