#include "UI.h"
#include "Graphics.h"
#include "Math.h"
#include "Bitmap.h"

namespace Menus {
    
    const int logo_sprite_data[] = {
        1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,
        1,0,0,0,0,1,1,0,0,1,
        1,0,0,0,0,1,1,0,0,1,
        1,1,1,1,1,1,1,1,1,1,
        1,0,0,1,1,0,0,1,1,1,
        1,0,0,1,1,0,0,1,1,1,
        1,0,0,0,0,0,0,0,0,1,
        1,0,0,0,0,0,0,0,0,1,
        1,1,1,0,0,1,1,0,0,1,
        1,1,1,0,0,1,1,0,0,1,
        1,1,1,1,1,1,1,1,1,1,
        1,0,0,0,0,0,0,0,0,1,
        1,0,0,0,0,0,0,0,0,1,
        1,1,1,1,1,1,1,1,1,1,
        1,0,0,0,0,1,1,0,0,1,
        1,0,0,0,0,1,1,0,0,1,
        1,0,0,1,1,0,0,1,1,1,
        1,0,0,1,1,0,0,1,1,1,
        1,0,0,0,0,0,0,0,0,1,
        1,0,0,0,0,0,0,0,0,1,
        1,1,1,1,1,1,1,1,1,1,
        1,0,0,1,1,1,1,1,1,1,
        1,0,0,1,1,1,1,1,1,1,
        1,0,0,0,0,0,0,0,0,1,
        1,0,0,0,0,0,0,0,0,1,
        1,0,0,1,1,1,1,1,1,1,
        1,0,0,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,
        1,0,0,1,1,1,1,0,0,1,
        1,0,0,1,1,1,1,0,0,1,
        1,0,0,0,0,1,1,0,0,1,
        1,0,0,0,0,1,1,0,0,1,
        1,0,0,0,0,0,0,0,0,1,
        1,0,0,0,0,0,0,0,0,1,
        1,1,1,1,1,1,1,1,1,1,
        1,0,0,1,1,1,1,1,1,1,
        1,0,0,1,1,1,1,1,1,1,
        1,0,0,0,0,0,0,0,0,1,
        1,0,0,0,0,0,0,0,0,1,
        1,0,0,1,1,1,1,1,1,1,
        1,0,0,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1,
        1,1,1,1,1,1,1,1,1,1
    };
    
    Bitmap logo_sprite(logo_sprite_data, 48, 10);
    
    UI::UI() {
        reset();
    }
    
    void UI::reset() {
        button_currently_selected = 0; 
    }
    
    UI::~UI() {
        
    }
    
    void UI::clear() {
        button_pressed_frame = false;
        next_y_pos = PADDING_Y;
        button_currently_drawing = -1;
        frame++;
    }
    
    void UI::drawTitle(const char * text) {
        drawLabel(text);
    }
    
    void UI::drawLabel(const char * text) {
        Graphics::UI::drawText(PADDING_X, nextY(), text);
    }
    
    void UI::drawFlashingLabel(const char * text) {
        Graphics::UI::drawText(PADDING_X, nextY(), (frame % 16) > 8 ? text : "");
    }
    
    void UI::newLine() {
        nextY();
    }
    
    int oldBorderX1,oldBorderY1, oldBorderX2, oldBorderY2;
    
    bool UI::drawAndCheckButton(const char * text) {
        button_currently_drawing++;
        
        int y = nextY();
        
        Graphics::UI::drawText(PADDING_X, y, text);
        
        bool selected = button_currently_drawing == button_currently_selected;
        
        int wordWidth = strlen(text) * (Graphics::UI::CHAR_WIDTH + Graphics::UI::CHAR_SPACE) - 1;
        
        if (selected) {
            int borderX1 = PADDING_X - 2;
            int borderY1 = y - 2;
            int borderX2 = PADDING_X + wordWidth + 2;
            int borderY2 = y + Graphics::UI::CHAR_HEIGHT + 1;
            Graphics::UI::drawBorder(
                Math::lerp(oldBorderX1, borderX1),
                Math::lerp(oldBorderY1, borderY1),
                Math::lerp(oldBorderX2, borderX2),
                Math::lerp(oldBorderY2, borderY2)
            );
            oldBorderX1 = Math::lerp(oldBorderX1, borderX1);
            oldBorderY1 = Math::lerp(oldBorderY1, borderY1);
            oldBorderX2 = Math::lerp(oldBorderX2, borderX2);
            oldBorderY2 = Math::lerp(oldBorderY2, borderY2);
        }
    
        return button_pressed_frame && selected;
    }
    
    void UI::drawLogo() {
        Graphics::UI::drawSprite(&logo_sprite, 0, 0);
        newLine();
    }
    
    void UI::selectNextButton() {
        if (button_currently_selected < button_currently_drawing) {
            button_currently_selected++;
        }
    }
    
    void UI::selectPreviousButton() {
        if (button_currently_selected > 0) {
            button_currently_selected--;
        }
    }
    
    void UI::pressButton() {
        button_pressed_frame = true;
    }
    
    int UI::nextY() {
        int currentYPos = next_y_pos;
        next_y_pos += Graphics::UI::CHAR_HEIGHT + LINE_PADDING;
        return currentYPos;
    }
};