#ifndef MENU_MANAGER_H
#define MENU_MANAGER_H

#include "Menu.h"

namespace Menus {
    /** 
     * Menus namespace
     * @brief A sub namespace of Menus containing functions the engine uses to
     * interface with the menus system. 
     * It uses a stack based menu management method.
     */
    namespace MenuManager {
        /**
         * @brief Called by the engine every frame 
         * when > 0 menus are on the stack, it both controls the menus, reacting
         * to input, and draws them at the same time.
         */
        void updateAndDraw();;
        
        /**
         * @returns the number of menus on the stack
         */
        int count();
        
        /**
         * @brief Adds a menu to the top of the menu stack
         * @params menu A pointer to the menu to add
         */
        void add(Menu * menu);
        
        /**
         * @brief Forcefully removes and deletes the top menu from the stack.
         * @see Menu.close
         */
        void close();
        
        /**
         * @brief closes all menus until the stack is empty
         */
        void closeAll();
    };
};

#endif