#include "UI.h"
#include "Engine.h"
#include "Input.h"
#include "Prefs.h"
#include "MenuManager.h"

namespace Menus {
    namespace MenuManager {
        int stack_top = -1;
        #define MAX_MENUS 16
        Menus::Menu * stack[MAX_MENUS];
        UI ui;
        void back();
        
        void updateAndDraw() {
            ui.clear();
            
            if (Input::buttonHit(Input::RIGHT)) {
                ui.pressButton();
            }
            
            stack[stack_top]->updateAndDraw(&ui);
            
            if (Input::buttonHit(Input::UP)) {
                ui.selectPreviousButton();
            }
            
            if (Input::buttonHit(Input::DOWN)) {
                ui.selectNextButton();
            }
            
            if (Input::buttonHit(Input::LEFT)) {
                back();
            }
        }
        
        int count() {
            return stack_top + 1;
        }
        
        void add(Menu * menu) {
            ui.reset();
            stack[++stack_top] = menu;
        }
        
        void back() {
            stack[stack_top]->close();
        }

        void close() {
            // no close if main or gameover is root
            if (count() > 0) {
                ui.reset();
                delete stack[stack_top--];
            }
        }
        
        void closeAll() {
            ui.reset();
            while (count() > 0) {
                ui.reset();
                delete stack[stack_top--];
            }
        }
    };
};
