#ifndef MENU_H
#define MENU_H

#include "UI.h"

/** 
 * Menus namespace
 * @brief Namespace containing the classes and functions used to instantiate, 
 * manage and draw menus.
 */
namespace Menus {
    /**
     * Menu class
     * @brief An abstract class representing a Menu the MenuManager could use
     */
    class Menu {
    public:
        /**
         * @brief Abstract method to manage and draw the ui elements with
         * @params ui The UI object you draw the menu with.
         * @see UI
         */
        virtual void updateAndDraw(UI * ui) = 0;
        
        /**
         * @brief Closes this menu via the menu manager.
         * Can be overriden to make the menu unclosable, or perhaps 
         * ask "are you sure" before closing.
         */
        virtual void close();
    };
}

#endif