#include "Grid.h"
#include "Graphics.h"

// returns lines cleared
int Grid::checkForLines() {
    int lines_cleared = 0;
    for (int j = GRID_HEIGHT - 1; j >= 0; j--) {
        for (int i = 0; i < GRID_WIDTH; i++) {
            if (grid[i][j] == false) {
                // if any empties, break
                break;
            } else {
                if (i == GRID_WIDTH - 1) {
                    Graphics::Game::shake(0, 4);
                    lines_cleared++;
                    shiftDownFrom(j);
                    // rows are now shifted down
                    // so check current row again
                    j = j + 1;
                }
            }
        }
    }
    return lines_cleared;
}

void Grid::shiftDownFrom(int row) {
    for (int j = row; j >= 0; j--) {
        for (int i = 0; i < GRID_WIDTH; i++) {
            // shift down
            if (j == 0) {
                grid[i][j] = false;
            } else {
                grid[i][j] = grid[i][j-1];
            }
        }
    }
}

bool Grid::isSpaceForTetromino(Tetromino tetromino) {
    for (int k = 0; k < 4; k++) {
        if (!isSpaceForBlock(tetromino.blocks[k])) {
            return false;
        }
    }
    return true;
}

bool Grid::isSpaceForBlock(Block block) {
    // can a block exist here?
    if (block.getX() > GRID_WIDTH - 1) {
        return false;
    } else if (block.getX() < 0) {
        return false;
    } else if (block.getY() > GRID_HEIGHT - 1) {
        return false;
    } else if (block.getY() < 0) {
        return false;
    } else {
        return grid[block.getX()][block.getY()] == false;
    }
}

// returns the score from placing the tetromino
int Grid::placeTetromino(Tetromino tetromino) {
    for (int i = 0; i < 4; i++) {
        grid[tetromino.blocks[i].getX()][tetromino.blocks[i].getY()] = true;
    }
    
    return checkForLines();
}

void Grid::draw() {
    Graphics::Game::drawBorder();
    
    for (int j = HIDDEN_HEIGHT; j < GRID_HEIGHT; j++) {
        for (int i = 0; i < GRID_WIDTH; i++) {
            if (grid[i][j] == true) {
                Graphics::Game::drawStripedBlock(i, j);
            }
        }
    }
}

Grid::Grid() {
    for (int j = 0; j < GRID_HEIGHT; j++) {
        for (int i = 0; i < GRID_WIDTH; i++) {
            grid[i][j] = false;
        }
    }
}