#ifndef ENGINE_H
#define ENGINE_H

#include "Game.h"

/** Engine namespace
 * @brief the root of the entire game, joining together all the modules
 */
namespace Engine {
    /**
     * The engine waits 1/FPS seconds before drawing the next frame
     */
    const float FPS = 24;
    
    /**
     * Initialise
     * @brief Initialises all the submodules, adds the main menu
     * and seeds the random generator.
     */
    void init();
    
    /**
     * Deinitalise
     * @brief Can be called to free memory used by the engine if needed.
     */
    void deinit();
    
    /**
     * Game loop
     * @brief called every 1/FPS seconds
     */
    void loop();
    
    /**
     * Starts a new game, overwriting the old one
     * @param difficulty The difficulty of the new game
     */
    void startGame(Game::Difficulty difficulty);
};

#endif