#ifndef BLOCK_H
#define BLOCK_H

/** Block class
 * @brief Class used to represent one of the four blocks
 * making up a Tetromino. @see Tetromino
 */
class Block {
public:
    /**
     * Constructs new a block
     * @param x The new block's x coordinate
     * @param y The new block's y coordinate
     * @returns A block at (x, y)
     */
    Block(int x, int y);
    
    /**
     * Constructs new a block
     * @returns A block at (0, 0)
     */
    Block();
    
    /**
     * Return this block moved by [dx, dy]
     * @param dx The amount to translate horizontally 
     * @param dy The amount to translate vertically
     * @returns A new block, like this but translated [dx, dy]
     */
    Block translated(int dx, int dy);
    
    /**
     * Accessor for x coordinate
     * @returns The x position
     */
    int getX();
    
    /**
     * Accessor for y coordinate
     * @returns The y position
     */
    int getY();
    
    /**
     * Return this block as if it were rotated about
     * the point (x, y)
     * @param x The x coordinate to rotate about
     * @param y The y coordinate to rotate about
     * @returns A new block, like this but rotated about (x, y)
     */
    Block rotateAround(int x, int y);
private:
    /**
     * The x position of the block
     */
    int x;
    
    /**
     * The y position of the block
     */
    int y;
};

#endif