#include "UnitTests.h"
#include "mbed.h"
#include "Tetromino.h"
#include "Grid.h"
#include "Prefs.h"
#include "Block.h"

void UnitTests::assertTrue(const char * description, bool result) {
    if (!result) {
        printf("Test '%s' FAILED!\n", description);
    }
}

void UnitTests::runAllTests () {
    testTetromino();
    printf("Run all Tetromino Tests\n");
    testBlock();
    printf("Run all Block Tests\n");
    testPrefs();
    printf("Run all Prefs Tests\n");
    testGrid();
    printf("Run all Grid Tests\n");
}

void UnitTests::testTetromino () {
    Tetromino test = Tetromino::getTetrominoOfType(Tetromino::T);
    Tetromino test_spun = test.rotatedClockwise()
        .rotatedClockwise()
        .rotatedClockwise()
        .rotatedClockwise();
    for (int i = 0; i < 4; i++) {
        bool same;
        if (test.blocks[i].getX() == test_spun.blocks[i].getX()
         && test.blocks[i].getY() == test_spun.blocks[i].getY()) {
            same = true;
        } else {
            same = false;    
        }
        assertTrue("4 rotations take you back to the beginning", same);
    }
}

void UnitTests::testBlock() {
    Block test = Block(44, 45);
    bool expected = test.getX() == 44 && test.getY() == 45;
    assertTrue("Block has accurate coordinates", expected);
}

void UnitTests::testPrefs() {
     Prefs::getInstance()->setKey(Prefs::LAST_PLAYER, 88);
     bool equal = Prefs::getInstance()->getKey(Prefs::LAST_PLAYER) == 88;
     assertTrue("Pref is retrived with the same value set", equal);
}

void UnitTests::testGrid() {
    Tetromino test_tetromino = Tetromino::getTetrominoOfType(Tetromino::T);
    Grid test_grid = Grid();
    test_grid.placeTetromino(test_tetromino);
    int no_space = !test_grid.isSpaceForTetromino(test_tetromino);
    assertTrue("Tetromino cannot be placed where there is no space", no_space);
}
