#include "Prefs.h"

Prefs * Prefs::instance = NULL;

Prefs::Prefs() {
    sd = new SDFileSystem(PTE3, PTE1, PTE2, PTE4, "sd"); // MOSI, MISO, SCK, CS
    read_file = fopen("/sd/prefs.txt", "r");
    if (read_file == NULL) {
        createFile();
    }
}

Prefs::~Prefs() {
    if (read_file != NULL) {
        fclose(read_file); 
    }
    delete sd;
}

Prefs * Prefs::getInstance() {
    if (instance == NULL) {
        instance = new Prefs();
    }
    return instance;
}

void Prefs::setKey(Key key, int value) {
    printf("prefs[%d] <- %d\n", key, value);
    if (read_file != NULL) {
        int oldValues[NUMBER_OF_PREFS];
        for (int i = 0; i < NUMBER_OF_PREFS; i++) {
            oldValues[i] = getKey((Key)i);
        }
        fclose(read_file);
        FILE * write_file = fopen("/sd/prefs.txt", "w");
        if (write_file != NULL) {
            for (int i = 0; i < NUMBER_OF_PREFS; i++) {
                fprintf(write_file, "%d\n", i == key ? value : oldValues[i]);
                fflush(write_file);
            }
        }
        fclose(write_file);
        read_file = fopen("/sd/prefs.txt", "r");
    }
}

int Prefs::getKey(Key key) {
    int value = EMPTY;
    if (read_file != NULL) {
        fseek(read_file, 0, SEEK_SET);
        for (int i = 0; i <= key; i++) {
            fscanf(read_file, "%d", &value);
        }
    }
    return value;
}

void Prefs::resetAll() {
    printf(" ! Resetting all prefs\n");
    fclose(read_file);
    FILE * write_file = fopen("/sd/prefs.txt", "w");
    for (int i = 0; i < NUMBER_OF_PREFS; i++) {
        fprintf(write_file, "%d\n", EMPTY);
    }
    fclose(write_file);
    read_file = fopen("/sd/prefs.txt", "r");
}

void Prefs::createFile() {
    printf(" ! Creating a new file\n");
    FILE * file = fopen("/sd/prefs.txt", "w");
    for (int i = 0; i < NUMBER_OF_PREFS; i++) {
        fprintf(file, "%d\n", EMPTY);
    }
    fclose(file);
}

void Prefs::printAll() {
    for (int i = 0; i < NUMBER_OF_PREFS; i++) {
        printf("prefs[%d]: %d\n", i, getKey((Key)i));
    }
}
