#include "Menu.h"

namespace Menus {
    /**
     * Scores Menu class
     * @brief Subclasses Menu, overriding updateAndDraw to make a menu
     * representing a scoreboard, showing the top 3 scores ever, and the
     * numbers of the players that scored them.
     */
    class ScoresMenu : public Menu {
    public:
        /**
         * @brief Constructor to load the data from prefs
         * into character buffers.
         */
        ScoresMenu();
        
        /**
         * @brief Draws the 3 scores, flashing your one if it's up there.
         */
        virtual void updateAndDraw(UI * ui);
    private:
        char highscores_labels[3][11];
        char players_lables[3][11];
        int last_player_pos;
    };
};