#include "ScoresMenu.h"
#include "Prefs.h"

Menus::ScoresMenu::ScoresMenu() {
    last_player_pos = -1;
    int last_player = Prefs::getInstance()->getKey(Prefs::LAST_PLAYER);
    
    int highscores[3];
    int players[3];
    
    players[0] = Prefs::getInstance()->getKey(Prefs::HIGHSCORE1_PLAYER);
    players[1] = Prefs::getInstance()->getKey(Prefs::HIGHSCORE2_PLAYER);
    players[2] = Prefs::getInstance()->getKey(Prefs::HIGHSCORE3_PLAYER);
    
    highscores[0] = Prefs::getInstance()->getKey(Prefs::HIGHSCORE1);
    highscores[1] = Prefs::getInstance()->getKey(Prefs::HIGHSCORE2);
    highscores[2] = Prefs::getInstance()->getKey(Prefs::HIGHSCORE3);
    
    for (int i = 0; i < 3; i++) {
        if (players[i] == Prefs::EMPTY) {
            sprintf(players_lables[i], "%1d.    ---", i + 1);
            sprintf(highscores_labels[i], " ");
        } else {            
            sprintf(players_lables[i], "%1d.PLYR %2d", i + 1, players[i]);
            sprintf(highscores_labels[i], "  %4dPTS", highscores[i]);
        }
    }
    
    for (int i = 0; i < 3; i++) {
        if (players[i] == last_player && highscores[i] != -1) {
            last_player_pos = i;
        }
    }
}

void Menus::ScoresMenu::updateAndDraw(UI * ui) {
    ui->drawTitle("hi scores");
    ui->newLine();
    for (int i = 0; i < 3; i++) {
        if (i == last_player_pos) {
            ui->drawFlashingLabel(players_lables[i]);
            ui->drawFlashingLabel(highscores_labels[i]);
        } else {
            ui->drawLabel(players_lables[i]);
            ui->drawLabel(highscores_labels[i]);
        }
    }
    if (ui->drawAndCheckButton("back")) {
        close();
    }
}