#include "Menu.h"

namespace Menus {
    /**
     * Paused Menu class
     * @brief Pauses the game due to the way the Engine is written - when a menu
     * is on the stack the game doesn't get updated.
     * Subclasses Menu, overriding updateAndDraw to show a resume button
     * and more.
     */
    class PausedMenu : public Menu {
    public:
        /**
         * @brief Draw the pause screen, the scores button and back button.
         */
        virtual void updateAndDraw(UI * ui);
    };
};