#include "Menu.h"

namespace Menus {
    /**
     * Main Menu class
     * @brief Subclasses Menu, overriding updateAndDraw to make the menu the
     * player sees when they start the game, with options and credits.
     */
    class MainMenu : public Menu {
    public:
        /**
         * @brief Prints the logo and buttons linking to the other submenus
         * @param ui The Ui object to draw with
         */
        virtual void updateAndDraw(UI * ui);
        
        /**
         * The close method is overridden to prevent it from being closed, 
         * as there would be nothing behind it.
         */
        virtual void close();
    };
};