#include "GameOverMenu.h"

#include "ScoresMenu.h"
#include "MainMenu.h"
#include "MenuManager.h"
#include "Prefs.h"
#include "mbed.h"

Menus::GameOverMenu::GameOverMenu() {
    int player_number = Prefs::getInstance()->getKey(Prefs::LAST_PLAYER);
    sd_working = player_number != -1;
    int score = Prefs::getInstance()->getKey(Prefs::LAST_SCORE);
    sprintf(score_text, "%5dPTS", score);
    sprintf(number_text, "PLYR%3d", player_number);
    new_high_score = false;
    for (int i = Prefs::HIGHSCORE1_PLAYER; i <= Prefs::HIGHSCORE3_PLAYER; i++) {
        if (player_number == Prefs::getInstance()->getKey((Prefs::Key)i)) {
            new_high_score = true;
        }    
    }
}

void Menus::GameOverMenu::close() {
    Menus::MenuManager::close();
    Menus::MenuManager::add(new MainMenu());
}

void Menus::GameOverMenu::updateAndDraw(UI * ui) {
    ui->drawTitle("game over");
    ui->newLine();
    if (sd_working) {
        ui->drawLabel(number_text);
        ui->drawLabel(score_text);
        if (new_high_score) {
            ui->drawFlashingLabel("new high");
            ui->drawFlashingLabel(" score!");
        }
    } else {
        ui->drawFlashingLabel(" sd card");
        ui->drawFlashingLabel(" error!");
    }
    ui->newLine();
    if (ui->drawAndCheckButton("scores")) {
        Menus::MenuManager::add(new ScoresMenu());
    }
    if (ui->drawAndCheckButton("back")) {
        close();
    }
}
