#ifndef MATH_H
#define MATH_H
    
/**
 * Namespace for maths-related helper functions
 */
namespace Math {
    /**
     * @brief lerp with a default value basically
     * a 'curried' lerp with t = 0.6
     * @see lerp
     * @returns lerp(a, b, 0.6)
     */
    int lerp(int a, int b);
    
    /**
     * @brief Linear Interpolation, but works for ints
     * so you never lerp to the same value twice, the 
     * minimum | a - b | is 1. 
     * @param a The starting value (t = 0)
     * @param b The value when t = 1
     * @param t The amount to interpolate
     * @returns a * (t - 1) + b * t
     */
    int lerp(int a, int b, double t);
}

#endif