#include "SampledIn.h"

SampledIn::SampledIn(PinName pin) {
    in = new DigitalIn(pin);
    in->mode(PullDown);
    ticker.attach(this, &SampledIn::sample, freq);
    last_in = 0;
    stable_output = 0;
    stable_frames = 0;
    last_value_returned = false;
}

SampledIn::~SampledIn() {
    delete in;    
}

bool SampledIn::hit_frame() {
    bool ret = stable_output == 1;
    if (ret == last_value_returned) {
        // never return true twice
        ret = false;
    }
    last_value_returned = stable_output;
    return ret;
}

void SampledIn::sample() {
    if (*(in) == last_in) {
        stable_frames += 1;
    } else {
        stable_frames = 0;
    }
    
    if (stable_frames > min_frames) {
        stable_output = *(in);
    }
    
    last_in = *(in);
}