#ifndef INPUT_H
#define INPUT_H

/**
 * Input Namespace
 * @brief Namespace providing functions to
 * interface with SampledIn objects for each button used.
 */
namespace Input {
    /**
     * @brief Button Enum represeting each button used for controling the game
     * The directional button are labeled as follows on the pcb
     * LEFT -> A 
     * RIGHT -> Y
     * UP -> X
     * DOWN -> B
     */
    enum Button {LEFT, RIGHT, UP, DOWN, START};
    
    /**
     * @input A button from the Button enum
     * @see Button
     * @returns True if the button was hit this frame, else false
     */
    bool buttonHit(Button button);
    
    /**
     * @returns A random seed for the random generator, 
     * based on the Analogue Input from the joystick.
     */
    int getSeed();
};
#endif