#include "Input.h"
#include "SampledIn.h"

namespace Input {
    
    SampledIn a_button(PTB9);
    SampledIn b_button(PTD0);
    SampledIn x_button(PTC17);
    SampledIn y_button(PTC12);
    SampledIn l_button(PTB18);
    SampledIn r_button(PTB3);
    SampledIn back_button(PTB19);
    SampledIn start_button(PTC5);
    
    bool buttonHit(Button button) {
        switch (button) {
            case LEFT:
                return a_button.hit_frame();
            case RIGHT:
                return y_button.hit_frame();
            case UP:
                return x_button.hit_frame();
            case DOWN:
                return b_button.hit_frame();
            case START:
                return start_button.hit_frame();
            default:
                return false;
        }
    }
    
    int getSeed() {
        AnalogIn noise(PTB11); // get noise from joystick horizontal axis
        return noise.read_u16();
    }
};