#include "Block.h"

Block Block::translated(int dx, int dy) {
    return Block(x + dx, y + dy);
}

Block::Block(int x, int y) {
    this->x = x;
    this->y = y;
}

Block::Block() {
    this->x = 0;
    this->y = 0;
}

int Block::getX() {
    return x;
}

int Block::getY() {
    return y;
}

Block Block::rotateAround(int x, int y) {  
    int new_x = this->x;
    int new_y = this->y;
    
    new_x -= x;
    new_y -= y;
    
    int final_x = new_y;
    int final_y = -new_x;
    
    final_x += x;
    final_y += y;
    
    return Block(final_x, final_y);
}
