/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name:Adam Jones
Username:el17aj
Student ID Number:201147452
Date:17/03/2019
*/

#include "main.h"

#define CROSSHAIRS_SPEED 3
#define FPS 16


int menu_cursor[7][7] =   {
    { 0,0,1,1,1,0,0 },
    { 0,1,0,0,0,1,0 },
    { 1,0,0,1,0,0,1 },
    { 1,0,1,1,1,0,1 },
    { 1,0,0,1,0,0,1 },
    { 0,1,0,0,0,1,0 },
    { 0,0,1,1,1,0,0 },
};



/////////////// structs /////////////////
struct UserInput {
    float angle;
    float mag;
};



/////////////// objects ///////////////
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
GameEngine game;

///////////// prototypes ///////////////
void init();
void update_game(UserInput input);
void render();
void welcome();
int check_button_press(int option);
void draw_menu_cursor(int option);
void play_game();
void game_over();

void how_to_play();
void instruction_1();
void instruction_2();
void instruction_3();

///////////// functions ////////////////
int main()
{

    int fps = FPS;  // frames per second

    init();     // initialise and then display welcome screen...
    welcome();  // creates welcome menu
    
    render();  // first draw the initial frame 
    wait(1.0f/fps);  // and wait for one frame period


}

// initialies all classes and libraries
void init()
{
    // need to initialise LCD and Gamepad 
    lcd.init();
    pad.init();
}

// this function draws each frame on the LCD
void render()
{
    // clear screen, re-draw and refresh
    lcd.clear();  
    game.draw(lcd);
    lcd.refresh();
}

// menu screen displayed on start-up
void welcome() {
    int option = 1; //integer to track the users selected menu item
    while (1) {
        lcd.clear();
        lcd.setContrast(pad.read_pot());    //in menu loop, allow contrast adjustment
        
        //draw menu on lcd
        lcd.printString(" Wall Defence!",0,0); 
        lcd.printString("  Play ",0,2);
        lcd.printString("  How To Play ",0,4);
        lcd.printString("(use Y/A/B) ", 0 , 5);
        
        //check button press to change or select option 
        option = check_button_press(option);
        
        //draw menu cursor next to new option
        draw_menu_cursor(option);
        
        //refresh the lcd to add new items then wait 1 frame
        lcd.refresh();
        wait(1/FPS);
    }
}

int check_button_press(int option)
{
    if ( pad.check_event(Gamepad::Y_PRESSED) == true) {
        option = 1; //play game option
    } else if ( pad.check_event(Gamepad::A_PRESSED) == true) {
        option = 2; //instructions option
    } else if ( pad.check_event(Gamepad::B_PRESSED) == true) {
        //pick current option
        if (option == 1) {
            play_game();
        } else if (option == 2) {
            how_to_play();
        }
    }
    return option;
}

void draw_menu_cursor(int option)
{
    if (option == 1) {
        lcd.drawSprite(0,15,7,7,(int *)menu_cursor);
    } else if (option == 2) {
        lcd.drawSprite(0,33,7,7,(int *)menu_cursor);
    }
}

void play_game() {
    //game initialised
    game.init(CROSSHAIRS_SPEED, FPS);
    //while game isnt over continue running game loop
    while (!game.get_game_over()) {
        lcd.setContrast(pad.read_pot());    //allows contrast adjustment throughout game, incase display can not be seen
        game.read_input(pad);   
        game.update(pad);
        render();
        wait(1.0f/FPS);
    }   
    game_over();    //displays game is over
}

void game_over() {
    lcd.clear();
    lcd.printString("  GAME OVER!  ",0,2);
    pad.tone(100, 1.0);
    lcd.refresh();
    wait(2.0);
}


void how_to_play() {
    instruction_1();    //joystick instruction message
    instruction_2();    //shoot instruction message
    instruction_3();    //games aim message 
}

void instruction_1()
{
    bool contPressed = false;
    
    lcd.clear();
    lcd.printString("Use Joystick",0,0);
    lcd.printString("To Aim",0,1);
    lcd.printString("(press B)",0,4);
    lcd.refresh();
    while (contPressed == false) {
        wait(0.2);
        if ( pad.check_event(Gamepad::B_PRESSED) == true) {
            contPressed = true;
        }
    }
}

void instruction_2()
{
    bool contPressed = false;
    
    lcd.clear();
    lcd.printString("Use B To Shoot",0,0);
    lcd.printString("(press B)",0,4);
    lcd.refresh();
    while (contPressed == false) {
        wait(0.2);
        if ( pad.check_event(Gamepad::B_PRESSED) == true) {
            contPressed = true;
        }
    }
}

void instruction_3()
{
    bool contPressed = false;
    
    lcd.clear();
    lcd.printString("Protect Your",0,0);
    lcd.printString("Wall",0,1);
    lcd.printString("(press B)",0,4);
    lcd.refresh();
    while (contPressed == false) {
        wait(0.2);
        if ( pad.check_event(Gamepad::B_PRESSED) == true) {
            contPressed = true;
        }
    }
}

