#ifndef WALL_H
#define WALL_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Wall Class
@author Adam Jones, University of Leeds
@brief Controls the Cross Hairs in the Wall Defence game
@date April 2017

@code
#include "N5110.h"
#include "Wall.h"



int main()
{   
    Wall _wall;
    

    //initialise wall object with 100 life
    _wall.init(100);
    
    //draw wall
    _wall.draw(lcd);
    
    //decrease walls health by 1
    _wall.take_damage(1);
    
    //get wall health
    int wallHealth = _wall.get_wall_health()
}

@endcode



*/ 
class Wall
{
    



public:
    Wall();
    ~Wall();
    /** 
    * @brief Initialises the Wall with a max health
    * @param max health @details integer representing the life of the wall
    */
    void init(int maxHealth);
    /** 
    * @brief Draws the wall on the display
    * @param lcd @details the N5110 screen object
    */
    void draw(N5110 &lcd);
    
    /** Health struct */
    struct Health {
        int current; /**< int for current */
        int max; /**< int for max */
    };
    
    /** 
    * @brief sets the wall health
    * @param health @details integer value 
    */
    void set_wall_health(int wall_health);
    /** 
    * @brief Returns integer value of wall health
    * @return wall health @details an integer value
    */
    int get_wall_health();
    
    /** 
    * @brief Does damage to the wall
    * @param damage @details an integer representing the amount of damage to the wall health
    */
    void Wall::take_damage(int damage);

private:
    
    Health _wallHealth;
    
};
#endif