#include "Wall.h"


//health icon
int healthSymbol[5][5] =   {
    { 1,1,1,1,1 },
    { 1,1,0,1,1 },
    { 1,0,0,0,1 },
    { 1,1,0,1,1 },
    { 1,1,1,1,1 },
};


Wall::Wall()
{

}

Wall::~Wall()
{

}

void Wall::init(int maxHealth)
{
    //set both current and max health of wall to the value in the initialiser
    _wallHealth.max = maxHealth;
    _wallHealth.current = maxHealth;


   
}

void Wall::draw(N5110 &lcd)
{
    //draw the wall
    lcd.drawRect(0,28,10,20,FILL_TRANSPARENT);
    lcd.drawLine(0,28,10,0,1);  //back top of wall
    lcd.drawLine(10,0,20,0,1);  //side of wall
    lcd.drawLine(10,28,20,0,1); //front top of wall
    lcd.drawLine(10,48,20,20,1); //front bottom of wall
    lcd.drawLine(20,20,20,0,1); //front side of wall
    
    //draw health symbol
    lcd.drawSprite(60,0,5,5,(int *)healthSymbol);
    
    //draw health value text to display
    char life[14];
    int length = sprintf(life,"%i",_wallHealth.current); // print formatted data to buffer
    // it is important the format specifier ensures the length will fit in the buffer
    if (length <= 14) {  // if string will fit on display (assuming printing at x=0)
        lcd.printString(life,67,0); 
    }
    
    
    
 
}

void Wall::set_wall_health(int wall_health) {
    _wallHealth.current = wall_health;
}

int Wall::get_wall_health() {
    return _wallHealth.current;
}


void Wall::take_damage(int damage) {
    _wallHealth.current -= damage;  //applies damage to the wall
}
