#ifndef GAMEENGINE_H
#define GAMEENGINE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Enemy.h"
#include "CrossHairs.h"
#include "EnemySpawner.h"
#include "Wall.h"



/** GameEngine Class
@author Adam Jones, University of Leeds
@brief Controls Game
@date April 2019
@brief Revision 1.0

@code
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "GameEngine.h"






int main()
{ 
    //initialise game object
    GameEngine game;
    int crossHairsSpeed = 5;
    int fps = 16
    game.init(crossHairsSpeed, fps);
    
    //read input from gamepad
    Gamepad pad;
    game.read_input(pad);
    
    //update game state
    game.update(pad);
    
    /draw game state
    game.draw(lcd);
    
    //returns if game is over or not
    bool isOver = game.get_game_over();
    
    //sets if game is over or not
    game.set_game_over(false); //false = not over, true = over

}

@endcode

*/


class GameEngine
{

public:
    GameEngine();
    ~GameEngine();

    /** 
    * @brief Initisalise the game with cross hair speed and frames per second
    * @param cross hairs speed @details max speed of the cross hairs in pixels per frame
    * @param fps @details the fps of the game
    */
    void init(int CrossHairsSpeed, int fps);
    /** 
    * @brief read input from gamepad
    * @param gamepad @details the gamepad object
    */
    void read_input(Gamepad &pad);
    /** 
    * @brief updates the gamepad based on inputs
    * @param gamepad @details the gamepad object
    */
    void update(Gamepad &pad);
    /** 
    * @brief draws sprites on the display
    * @param lcd @details the N5110 object
    */
    void draw(N5110 &lcd);
    /** 
    * @brief returns if the game is over or not
    * @return game over @details a boolean value
    */
    bool get_game_over();
    
    /** 
    * @brief sets if game is over or not
    * @param game over @details a boolean value
    */
    void set_game_over(bool is_game_over);
    
private:


    void fireShot(Gamepad &gpad);
    
    void was_enemy_shot(int i, Vector2D shotLoc);
    void game_over();

    bool _game_over;
    int _frame;
    int _fps;

    int _levelNumber;
    int _killCount;
     
    
    float _angle;
    float _mag;
    
    CrossHairs _crossHairs;
    
    Wall _wall;
    
    
    Enemy *_enemies;
    EnemySpawner _level;
    
    
    
    
    
    

 

    
    

    
    

};

#endif