#include "GameEngine.h"



GameEngine::GameEngine()
{

}

GameEngine::~GameEngine()
{

}

void GameEngine::init(int CrossHairsSpeed, int fps)
{
    // initialise the game parameters
    _game_over = false;
    _fps = fps;
    _frame = 0; //keep count of number of frames
    _levelNumber = 1;   //keep count of number of frames
    _killCount = 0; //keep count of number of enemies killed
    
    //initialise wall object with max life
    _wall.init(100);
    
    //initialise cross hairs with cross hairs speed
    _crossHairs.init(CrossHairsSpeed);
    
    //seed random with time
    srand(time(NULL));
    
    //set enemies pointer to point to array of enemies
    _enemies = _level.init(_levelNumber);
    


    
    
    
    
}

void GameEngine::read_input(Gamepad &pad)
{
    _angle = pad.get_angle();
    _mag = pad.get_mag();
}

void GameEngine::draw(N5110 &lcd)
{
    //print level number at top of display
    char level[14];
    sprintf(level,"lvl:%i",_levelNumber);
    lcd.printString(level,23,0); 
    
    //draw wall
    _wall.draw(lcd);
    
    //draw all enemies
    for (int i=0; i < _level.get_number_of_enemies(); i++) {
        _enemies[i].draw(lcd);
    }
    
    //draw cross hairs
    _crossHairs.draw(lcd);
}

void GameEngine::update(Gamepad &pad)
{
    //increment frame count 
    _frame = _frame + 1;
    
    /*if statement finds modulus of frame by fps/2 and checks if equal to 0
    /this will be true every half second
    /when this is true if an enemies state is that it is attacking the wall
    /the wall will be damaged
    */
    if (_frame%(_fps/2) == 0) {
        for (int i=0; i < _level.get_number_of_enemies(); i++) {
            if(_enemies[i].get_current_action() == attacking) {
                _wall.take_damage(1);
                if (_wall.get_wall_health() <= 0) {
                    game_over();    //if wall health gets to zero game is over
                }
            }
        }
    }
    
    //update the level object
    _level.update(_fps);
    //update cross hairs object
    _crossHairs.update(_angle,_mag);
    
    //update all enemies
    for (int i=0; i < _level.get_number_of_enemies(); i++) {
        _enemies[i].update(_fps);
    }
    
    //check if either A or B are pressed, if true fire shot
    if ( pad.check_event(Gamepad::B_PRESSED) == true) {
        fireShot(pad);
    } else if ( pad.check_event(Gamepad::A_PRESSED) == true) {
        fireShot(pad);
    }
    
        
    
}

void GameEngine::fireShot(Gamepad &gpad)
{
    gpad.tone(400, 0.1);    //gunshot noise
    Vector2D shotLoc = _crossHairs.get_pos();   //get cross hairs location to get shot location
    //check if enemies are alive
    for(int i = 0; i < _level.get_number_of_enemies(); i++) {
        if (_enemies[i].get_alive()) {
            //function finds if enemy i has been shot
            was_enemy_shot(i, shotLoc);
        }
    }
}

void GameEngine::was_enemy_shot(int i, Vector2D shotLoc)
{
    Vector2D enemyLoc = _enemies[i].get_pos();  //get enemy position
    //compare x and y distance of enemy and shot and if it is less than 4 enemy is shot
    if (abs(enemyLoc.x - shotLoc.x) < 4 && abs(enemyLoc.y - shotLoc.y) < 4) {
        _killCount = _killCount + 1;    //incriment kill count
        _enemies[i].set_alive(false);   //set alive flag to false
        //set enemy action to dying
        Action myAc;   
        myAc = dying;
        _enemies[i].set_current_action(myAc);
                    
        //checks if the kill count has reached the enemy number of level   
        if (_killCount == _level.get_number_of_enemies()) {
            _killCount = 0; //resets kill count
            _levelNumber = _levelNumber + 1;    //incriments level number
            _enemies = _level.init(_levelNumber);   //initialise new level and set pointer to new enemy array
        }
    }
            
  
}

bool GameEngine::get_game_over() {
    return _game_over;  //true if over, false if not
    
}
void GameEngine::set_game_over(bool is_game_over) {
    _game_over = is_game_over;  //true if over, false if not
}

void GameEngine::game_over() {
    _game_over = true;  //sets the game as over
    
}
