#ifndef ENEMYSPAWNER_H
#define ENEMYSPAWNER_H

#include "mbed.h"
#include "Gamepad.h"
#include "Enemy.h"


/** EnemySpawner Class
@author Adam Jones, University of Leeds
@brief Creates and controls the levels of the game
@date April 2019
@brief Revision 1.0

@code
#include "Enemy.h"
#include "mbed.h"
#include "Gamepad.h"


int main()
{ 
    //setup pointer to enemy array
    Enemy *_enemies;
    //setup level enemy spawner object 
    EnemySpawner _level;
    
    
    //create level and return array of enemies
    int _levelNumber = 1 //integer level number
    _enemies = _level.init(_levelNumber);
    
    //returns number of enemies in level
     int numOfEnemies = _level.get_number_of_enemies()
     
     //updates level 
    _level.update(_fps);
}

@endcode


*/ 


class EnemySpawner
{

public:
    EnemySpawner();
    ~EnemySpawner();

    /** 
    * @brief Initialises the game level
    * @param level @details the number of the level of the game
    * @returns Enemy* @details a pointer to an array of enemy objects 
    */
    Enemy* init(int level);
    
    /** 
    * @brief Updates to keep track of the time and tell indicidual enemies when to begin moving
    * @param fps @details the fps of the game
    */
    void update(int fps);
    
    /** 
    * @brief Gets the number of enemies in level
    * @returns number of enemies @details an integer value of the number of enemies in the level
    */
    int get_number_of_enemies();
    
private:
    float _minTimeBetweenSpawns;
    float _timeIntoLevel;
    int _number_of_enemies;
    Enemy *_enemies;
    int _level;
};

#endif