#include "EnemySpawner.h"


EnemySpawner::EnemySpawner()
{

}

EnemySpawner::~EnemySpawner()
{

}

Enemy* EnemySpawner::init(int level)
{ 
    //seed random number with time to give truly random values
    srand(time(NULL));
    
    //set the time tracking variable to 0
    _timeIntoLevel = 0.0;
    _level = level;
    _number_of_enemies = level; //sets number of enemies equal to level number
    
    
    //sets the minimum time between enemy spawns to decrease as level increases, up to a minimum
    _minTimeBetweenSpawns = 1.0f - (level*0.2f);
    if(_minTimeBetweenSpawns<0.1) {
        _minTimeBetweenSpawns=0.1;
    }
        
    //allocate memory for array of enemies 
    _enemies = (Enemy*)malloc(sizeof(Enemy)*_number_of_enemies);
    
    //initialise each enemy and add it to array
    //time to attack increases with each enemy added to ensure they are spaced out
    float timeToAttack = 0.0;
    for (int i=0; i < _number_of_enemies; i++) {
        timeToAttack = timeToAttack + _minTimeBetweenSpawns;    //incriment time to attack by minimum time between
        int variation = rand() % 100;   
        float actualVar = variation/100.0f; //add a second of variation between spawns to add unpredictability
        timeToAttack = timeToAttack + actualVar;
        float speed = 0.5 + ((rand() % 100)/100.0); //set speed to a minumim 0.5 up to a max of 1.5 to add unpredictability
        
        //initialise this enemy with the desired speed and time to attack
        _enemies[i].init(timeToAttack, speed);
    }
    
    return _enemies;
}

    

void EnemySpawner::update(int fps)
{
    //incriment time
    _timeIntoLevel += 1.0f/fps;
    
    
    //checks if the time in to the level is higher than enemies time to attack
    //if so it changes the emenies state so it begins to move forwards
    for (int i=0; i < _number_of_enemies; i++) {
        if(abs(_enemies[i].get_timeToAttack() - _timeIntoLevel) < 0.2) {
            Action myAc;
            myAc = moving;
            _enemies[i].set_current_action(myAc);
        }
    }
    
}

int EnemySpawner::get_number_of_enemies() {
    return _number_of_enemies;
}


