#ifndef ENEMY_H
#define ENEMY_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include <time.h>


/** CrossHairs Class
@author Adam Jones, University of Leeds
@brief Controls the Enemy Sprites in the Wall Defence game
@date April 2019
@brief Revision 1.0

@code
#include "Enemy.h"
#include "N5110.h"


int main()
{ 
    //initialise
    float timeToAttack = 0.0;   //time at which the enemy will begin to move forwards
    float speed = 0.5;  //speed in pixels per frame at which enemy will move forwards
    Enemy _enemy;
    _enemy.init(timeToAttack, speed);
    
    //set action
    Action myAc = moving; //Action enumerator
    _enemy.set_current_action(myAc);  //set enemies current action
    
    //get action
    myAc = _enemy.get_current_action();
    
    //get position
    enemy.get_pos()
    
    //set position
    Vector2D p = {2, 2} //{x,y}
    enemy.set_pos(p);
    
    //get time at which enemy will begin moving
    float time = get_timeToAttack();
    
    //set enemies alive flag true/false
    enemy.set_alive(true);
    
    //get enemies alive flag true/false
    enemy.get_alive();
    
    
    //update enemy 
    int fps = 30;
    enemy.update(int fps);
    
    
    //draw enemy 
    N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
    lcd.init();
    _enemy.draw(lcd);  //draw enemy sprite to display 
    
    
    
    
    
    
}

@endcode


*/ 

//action enumerator keeps track of enemies current state
//and allows for quick routing to correct process via switch state
enum Action { 
    waiting,    //enemy not yet attacking (off screen)
    moving,     //enemy moving towards players wall
    attacking,  //enemy damaging players wall
    dying       //enemy has been killed by player 
};

class Enemy
{
public:
    Enemy();
    ~Enemy();
    
    
    /** 
    * @brief Initialises an enemy with a time to attack and a set speed 
    * @param timeToAttack @details The time into the new level that the enemy will start moving forwards
    * @param speed @details The speed of the enemy in pixels per frame
    */
    void init(float timeToAttack, float speed);
    /** 
    * @brief Draws the enemy on the lcd
    * @param lcd @details the N5110 object
    */
    void draw(N5110 &lcd);
    /** 
    * @brief Updates the position of the enemy based on its state
    * @param fps @details the games frames per second as an integer
    */
    void update(int fps);
    
    /// accessors and mutators
    /** 
    * @brief Gets the enemies position
    * @return position @details a Vector2D object detailing enemies position

    */
    Vector2D get_pos();
    /** 
    * @brief Sets the enemies position
    * @param position @details a Vector2D position
    */
    void set_pos(Vector2D p);
    
    /** 
    * @brief Gets the enemies delay time to it starting to attack
    * @return time to attack @details returns a float value for the time in to the level the enemy begins to attack
    */
    float get_timeToAttack();
    
    /** 
    * @brief Sets enemies current action
    * @param Action @details an enumerator with 1 of the following values { waiting, moving, attacking, dying };
    */
    void set_current_action(Action act);
    /** 
    * @brief Returns enemies current action
    * @return Action @details an enumerator with 1 of the following values { waiting, moving, attacking, dying };
    */
    Action get_current_action();
    /** 
    * @brief Set Flag if enemy is alive
    * @param alive @details a boolean value detailing if the enemy is alive
    */
    void set_alive(bool alive);
    /** 
    * @brief Get Flag if enemy is alive
    * @return alive @details a boolean value detailing if the enemy is alive
    */
    bool get_alive();
    
    
private:

    float _x;
    float _y;
    
    bool _attack;
    bool _alive;
    float _timeToAttack;
    float _speed;
        
    float _animationTick; 
    Action currentAction;
    

    
    
};
#endif