#include "Enemy.h"





//enemy walking version A for animation
int enemyWalkA[8][5] =   {
    { 0,0,1,0,0 },
    { 0,1,0,1,0 },
    { 0,0,1,0,0 },
    { 1,1,1,0,0 },
    { 0,0,1,0,0 },
    { 0,1,1,1,0 },
    { 0,1,0,1,1 },
    { 1,1,0,0,0 },
};

//enemy in normal standing state
int enemyNormal[8][5] =   {
    { 0,0,1,0,0 },
    { 0,1,0,1,0 },
    { 0,0,1,0,0 },
    { 0,1,1,0,0 },
    { 0,0,1,0,0 },
    { 0,0,1,0,0 },
    { 0,0,1,0,0 },
    { 0,1,1,0,0 },
};

//enemy dead state
int enemyDead[5][8] =   {
    { 0,0,0,0,0,0,0,0 },
    { 0,1,0,0,0,0,0,0 },
    { 1,0,1,1,1,1,1,1 },
    { 0,1,0,0,0,0,0,0 },
    { 0,0,0,0,0,0,0,0 },
};

//enemy attacking state 1 for animation
int enemyAttack[8][5] =   {
    { 1,0,1,0,0 },
    { 1,1,0,1,0 },
    { 1,0,1,0,0 },
    { 0,1,1,0,0 },
    { 0,0,1,0,0 },
    { 0,0,1,0,0 },
    { 0,0,1,0,0 },
    { 0,1,1,0,0 },
};

//enemy attacking state 2 for animation
int enemyAttack2[8][5] =   {
    { 0,0,1,0,0 },
    { 0,1,0,1,0 },
    { 0,0,1,0,0 },
    { 1,1,1,0,0 },
    { 0,0,1,0,0 },
    { 0,0,1,0,0 },
    { 0,0,1,0,0 },
    { 0,1,1,0,0 },
};

Enemy::Enemy()
{

}

Enemy::~Enemy()
{

}

void Enemy::init(float timeToAttack, float speed)
{
    //set current action as waiting 
    currentAction = waiting;
    
    
    _x = WIDTH;  //set initial position off far right of screen
    _attack = false;    //set attack flag as false
    _alive = true;  //set alive flag true
    _timeToAttack = timeToAttack;  //set time to attack 
    
    int yStart = (rand() % (HEIGHT-16)) + 8; // randomise initial y coordinate with offsets so enemies appear fully on screen. 
    _y = yStart;
    

    _speed = speed;  //set enemies speed 
   
}

void Enemy::draw(N5110 &lcd)
{

    //switch state decides which version of the sprite to draw based on the the current action 
       switch(currentAction)
    {
        case waiting :  
        { 
            break;
        }
        case moving: 
        {
            //animation tick keeps track in ms of time
            //modulus by 100 is found then if number is less than half way it will draw one sprite version else it draws another
            //creates animation sprite changes every 50ms
            if ((int)_animationTick%100 < 50)
            {
                lcd.drawSprite(_x,_y,8,5,(int *)enemyWalkA);
            } else {
                lcd.drawSprite(_x,_y,8,5,(int *)enemyNormal);
            }
            break;
        }
        case attacking : 
        {
            //animation tick keeps track in ms of time
            //modulus by 1000 is found then if number is less than half way it will draw one sprite version else it draws another
            //creates animation sprite changes every 500ms
            if ((int)_animationTick%1000 < 500)
            {
                lcd.drawSprite(_x,_y,8,5,(int *)enemyAttack2);
            } else {
                lcd.drawSprite(_x,_y,8,5,(int *)enemyAttack);
            }
            break;
        }
        case dying : 
        {
            //animation tick keeps track in ms of time
            //after 1 second it no longer will draw the sprite
            if (_animationTick < 1000)
            {
                lcd.drawSprite(_x-3,_y+5,5,8,(int *)enemyDead);
            }
            
            break;
        }
    }
}

void Enemy::update(int fps)
{
    //update animation tick which is used in draw method
    _animationTick = _animationTick + (1000.0/fps);
    
    //update the enemy based on which state it is in
    switch(currentAction)
    {
        case waiting :  
        { 
            break;
        }
        case moving: 
        {
            _x-= _speed;    //update x position 
            //code to stop enemy when wall is reached
            float xOfWall = (_y - 76)/(-2.8);    //equation of bottom line of wall y=mx+c re-arranged
            //when wall is reached set state of enemy to attacking
            if(_x < xOfWall) {
                _x = xOfWall;
                currentAction = attacking;
            }
            break;
        }
        case attacking : 
        {
            break;
        }
        case dying : 
        {
            break;
        }
    }
}



Vector2D Enemy::get_pos()
{
    Vector2D p = {_x,_y};
    return p;
}

void Enemy::set_pos(Vector2D p)
{
    _x = p.x;
    _y = p.y;
}


float Enemy::get_timeToAttack()
{
    return _timeToAttack;  
}


void Enemy::set_current_action(Action act) {
    _animationTick = 0.0;   //resets the animation tick when new action begins
    currentAction = act;
}

Action Enemy::get_current_action() {
    return currentAction;
}


void Enemy::set_alive(bool alive)
{
    _alive = alive;
}

bool Enemy::get_alive()
{
    return _alive;
}




