#ifndef CROSSHAIRS_H
#define CROSSHAIRS_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** CrossHairs Class
@author Adam Jones, University of Leeds
@brief Interacts with the Cross Hairs which the user uses to aim in the game
@date April 2019
@brief Revision 1.0

@code
#include "N5110.h"

int crossHairsSprite[7][7] =   {
    { 0,0,1,1,1,0,0 },
    { 0,1,0,0,0,1,0 },
    { 1,0,0,1,0,0,1 },
    { 1,0,1,1,1,0,1 },
    { 1,0,0,1,0,0,1 },
    { 0,1,0,0,0,1,0 },
    { 0,0,1,1,1,0,0 },
};


int main()
{
    // first need to initialise display
    lcd.init();
    
    //make object of cross hairs class
    CrossHairs _crossHairs; 
    
    //initialise cross hairs object
    _crossHairs.init(CrossHairsSpeed);
    
    float _angle = 180.0 // degrees
    float _mag = 1.0 // magnitude 0.0 to 1.0
    //update position of cross hairs
    _crossHairs.update(_angle,_mag);
    
    //call to add cross hairs to screen
    _crossHairs.draw(lcd);
    
    //returns Vector2D position
    Vector2D crossHairsLoc = _crossHairs.get_pos();
    
    
    Vector2d newPos = = {10,20}; //{x,y};
    //set cross hairs position
    _crossHairs.setPos(newPos);
}
@endcode


*/ 





class CrossHairs
{

public:
    CrossHairs();
    ~CrossHairs();
    /** 
    * @brief Initialises the cross hairs at center position
    * @param speed @details Speed of cross hairs in pixels per frame (integer)
    */
    void init(int speed);
    /** 
    * @brief Draws the cross hairs on the lcd
    * @param lcd @details the N5110 object
    */
    void draw(N5110 &lcd);
    /** 
    * @brief Updates the position of the cross hairs based on user input
    * @param angle @details angle in degrees
    * @param magnitude @details magnitude from 0.0 to 1.0 to allow user to control speed of motion
    */
    void update(float angle,float mag);
    
    /// accessors and mutators
    /** 
    * @brief gets the position of the cross hairs
    * @returns a Vector2D value of the coordinates
    */
    Vector2D get_pos();
    /** 
    * @brief sets the position of the cross hairs
    * @param position @details Vector2D coordinate value
    */
    void set_pos(Vector2D p);
    
private:

    float _x;
    float _y;
    int _speed;
    
};
#endif