#include "CrossHairs.h"


int crossHairsSprite[7][7] =   {
    { 0,0,1,1,1,0,0 },
    { 0,1,0,0,0,1,0 },
    { 1,0,0,1,0,0,1 },
    { 1,0,1,1,1,0,1 },
    { 1,0,0,1,0,0,1 },
    { 0,1,0,0,0,1,0 },
    { 0,0,1,1,1,0,0 },
};

CrossHairs::CrossHairs()
{

}

CrossHairs::~CrossHairs()
{

}

void CrossHairs::init(int speed)
{
    //set the cross hairs x and y to centre of display
    _x = WIDTH/2 -  (7/2);
    _y = HEIGHT/2 - (7/2);
    
    //set the cross hairs max speed in pixels per frame
    _speed = speed;


   
}

void CrossHairs::draw(N5110 &lcd)
{
    // x origin, y origin, rows, cols, sprite
    lcd.drawSprite(_x,_y,7,7,(int *)crossHairsSprite);
 
}

void CrossHairs::update(float angle,float mag)
{
    //Correcting JoyStick angle to match screen angles
    angle = angle - 90.0f;
    
    //Conversion To Radians
    double angleRads = (angle/360.0f)*2.0f*3.14f;
    
    //incriment x and y based on an angle and magnitude 
    _x+= _speed*mag*cos(angleRads);
    _y += _speed*mag*sin(angleRads);
    
    //check if cross hairs are outside screen boundary
    //if they are outside the boundary set the problem coordinate to the boundary
    int halfCrossHairs = 3;
    if (_x < -halfCrossHairs) {
        _x = -halfCrossHairs;
    } else if (_x > 84-halfCrossHairs) {
        _x = 84-halfCrossHairs;
    }
    if (_y < -halfCrossHairs) {
        _y = -halfCrossHairs;
    } else if (_y > 48-halfCrossHairs) {
        _y = 48-halfCrossHairs;
    }
        
}



Vector2D CrossHairs::get_pos()
{
    Vector2D p = {_x,_y};
    return p;
}

void CrossHairs::set_pos(Vector2D p)
{
    _x = p.x;
    _y = p.y;
}