#ifndef MAIN_H
#define MAIN_H

/** @file main.h
 *  @brief Main.cpp's header file. contsins all objects, constants and prototypes used in
 *main.cpp
 */
 
//______________pre-processor directives________________________________________
#include "mbed.h"
#include "N5110.h"
#include "RosenEngine.h"
#include "Menu.h"

#ifdef WITH_TESTING
# include "test.h"
#endif

//_______________objects________________________________________________________
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
RosenEngine rosen;
Menu menu;

//_______________prototypes_____________________________________________________
void init();
void welcome();
void render();
void ship_select();
void display_help();

//_______________constants______________________________________________________
int fps = 12; // Frames per second

#endif