/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name: Ikenna Adrian Ozoemena
Username: el17aio
Student ID Number: 201157039
Date: 20/02/2019
*/

#include "main.h"
/** @file main.cpp
 *  @brief Main file used to run the game using the game engine RosenEngine
 */


//_______________functions______________________________________________________
int main()
{
    // adds testing to the main file if it is declared in macros
#ifdef WITH_TESTING
    int number_of_failures = run_all_tests();

    if(number_of_failures > 0) return number_of_failures;
#endif

    // initialize game objects and engine
    init();
    while(1) {
        welcome();
        rosen.reset();
        if(rosen.get_ycursor() == 16) {
            while ( pad.check_event(Gamepad::BACK_PRESSED) == false && rosen.dead() == false) {
                rosen.read_input(pad);
                rosen.update(pad);
                render();
                wait(1.0f/fps);
                rosen.timer(fps);
            }
        }
        if(rosen.get_ycursor() == 24) {
            while ( pad.check_event(Gamepad::BACK_PRESSED) == false) {
                rosen.read_input(pad);
                rosen.update(pad);
                ship_select();
                wait(1.0f/fps);
            }
        }
        if(rosen.get_ycursor() == 32) {
            while ( pad.check_event(Gamepad::BACK_PRESSED) == false) {
                rosen.read_input(pad);
                rosen.update(pad);
                display_help();
                wait(1.0f/fps);
            }
        }
    }
}

void init()
{
    // need to initialise LCD and Gamepad
    lcd.init();
    pad.init();
    rosen.init(9,6,3,42,41);
    printf("Initializing...\n");

}
void render()
{
    // clear screen, re-draw and refresh
    lcd.clear();
    rosen.draw(lcd, pad);
    rosen.get_pos();
    lcd.refresh();
    // printf("Rendering...\n");
}
void ship_select()
{
    lcd.clear();
    rosen.ship_select(lcd);
    rosen.get_pos();
    lcd.refresh();
    // printf("Ship Select...\n");
}
void display_help()
{
    lcd.clear();
    rosen.get_pos();
    rosen.help(lcd);
    lcd.refresh();
    // printf("Ship Select...\n");
}

void welcome()
{
    while( pad.check_event(Gamepad::START_PRESSED) == false) {
        lcd.clear();
        rosen.title(lcd);
        rosen.read_input(pad);
        lcd.refresh();
    }
    // printf("Welcome Function completed...\n");
}