#ifndef WEAPONS_H
#define WEAPONS_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Ship.h"
#include "Enemy.h"

           
/** Weapon Class
@brief Draws the weapons used by all ships in the game
@author Ozoemena Adrian Ikrnna
@date 8th May 2019
*/

class Weapons
{
    public:
    /** constructor */
    Weapons();
    /** destructor */
    ~Weapons();
    
     
    /** A mutator method that initializes the value of the ship position and ship width
    *@param ship_xpos the x position of the ship
    *@param ship_ypos the y position of the ship
    *@param ship_width the width of the ship
    */
    void init(int ship_xpos, int ship_ypos, int ship_width);
    /** Draws the appropriate weapon depending on the ship selected
    *@param &lcd address of the N5110 library used for the lcd display
    *@param &pad address of the gamepad library used to read inputs and send outputs to the gamepad
    *@param shipUsed a variable of enum SHIP which contains the ship currently being used 
    *@param closest the position vector of the nearest enemy
    */
    void draw(N5110 &lcd,Gamepad &pad,SHIP shipUsed,Vector2D closest);
    /** Accessor method that gets the position of the projectile where applicable(depends on ship)
    *@param shipUsed a variable of enum SHIP which contains the ship currently being used 
    @returns the 2D vector of the projectile fired from ship
    */
    Vector2D get_pos(SHIP _shipUsed);
    /** Updates the missle position based on the missle velocity
    */
    void update();
    /** Mutator function used to set the position of the projectile to a specific coordinate on screen. 
    *used to reset the projectile after a collision with an enemy
    *@param xpos the ships x co-ordinate
    *@param ypos the ships y co-ordinate
    */
    void set_pos(int xpos, int ypos);
    
    private:
    //_______________Private-Variables__________________________________________
    Enemy _enemy; 
    int _ship_xpos; // ship's x co-ordinate
    int _ship_ypos; // ship's y co-ordinate
    int reset;      // variable to reset the kestrels missle
    Vector2D _velocity; // vector to contain the velocity of the kestrels missle
    int _x;         // missle x co-ordinate
    int _y;         // missle y co-ordinate
    
};
#endif