#ifndef TEST_H
#define TEST_H

#include "Engine-test.h"

/**
 * @brief Run all the tests for this program
 *
 * @returns The number of tests that failed
 */
int run_all_tests()
{
    int testsFailed = 0; // A log of the number of tests that have failed
    
    // test initialization
    printf("Testing Initialization...\n");
    
    bool initTest = test_init();
    if (initTest) {
        printf("...Initialization Passed!\n");
    }
    else {
        printf("...Initialization FAILED!\n");
        ++testsFailed; // Increment number of failures
    }
    
    bool colTest = test_collision();
    if (colTest) {
        printf("...Collision Passed!\n");
    }
    else {
        printf("...Collision FAILED!\n");
        ++testsFailed; 
    }
    
    // The check_collision1 function being tested is mainly used for the imperions lazer
    bool colTest1 = test_collision1();
    if (colTest1) {
        printf("...Collision(Imperion) Passed!\n");
    }
    else {
        printf("...Collision(Imperion) FAILED!\n");
        ++testsFailed; // Increment number of failures
    }


    // Finish by printing a summary of the tests
    if (testsFailed > 0) {
        printf("%d tests FAILED!\n", testsFailed);
    }
    else {
        printf("All tests passed!\n");
    }
    return testsFailed; 
}

#endif