#ifndef SHIP_H
#define SHIP_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
/** A enum to store the three playable ships*/
enum SHIP{kestrel, /** The first one  */
          imperion, /** The best one */
          orion,}; /** The one for people who can't aim */

/** Ship Class
@brief Library for drawing and updating the ship used in game
@author Ozoemena Adrian Ikenna
@date 8th May 2019
*/
class Ship
{

public:
    /** constructor */
    Ship();
    /** destructor */
    ~Ship();
    /** A mutator method that initializes the value of the ship size, speed and position
    *@c(The ships width, height and speed differ from ship to ship)
    *@param ship_width the width of the ship
    *@param ship_height the height of the ship
    *@param ship_speed the speed of the ship
    *@param ship_xpos the y position of the ship
    *@param ship_ypos the x position of the ship
    */
    void init(int ship_width,int ship_height,int ship_speed,int _ship_xpos,int _ship_ypos);
    /** Draws the ship based on the ship being used
    *@param &lcd address of the N5110 library used for the lcd display
    *@param shipUsed a variable of enum SHIP which contains the ship currently being used 
    */
    void draw_ship(N5110 &lcd, SHIP shipUsed);
    /** Mutator method that changes the ships position based on joystick input
    *@param x_joystick the xjoystick value
    *@param y_joystick the yjoystick value
    */
    void update_ship(float x_joystick,float y_joystick);
    /** An accesor method used to get the ships position
    *@returns the ships position
    */
    Vector2D get_pos();
    /** A mutator method set the ships speed and dimensions when ship being used is changed
    *@param ship_width the width of the ship
    *@param ship_height the height of the ship
    *@param ship_speed the speed of the ship
    */
    void set_parameters(int ship_width, int ship_height,int ship_speed);
    
private:
    //_______________Private-Variables__________________________________________
    int _ship_width;   // the ships width along the x-axis
    int _ship_height;  // the ships height along the y-axis
    int _ship_speed;   // the ships speed
    int _ship_xpos;    // the ships x position
    int _ship_ypos;    // the ships y position

};

#endif