#ifndef MENU_H
#define MENU_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Ship.h"

/** Menu Class
@brief Library for displaying menu screen
@author Ozoemena Adrian Ikenna
@date 8th May 2019
*/
class Menu
{
    public:
    /** constructor */
    Menu();
    /** deconstructor */
    ~Menu();
    
    /** A mutator method that initializes the cursor used to select options in the menu
    *@param ycursor the yposition of the rectangle used as a cursor
    */
    void init(int ycursor);
    /** Displays the title screen and changes the displayed ship based on ship selected
    *@param &lcd address of the N5110 library used for the lcd display
    *@param shipUsed a variable of enum SHIP which contains the ship currently being used 
    */
    void title(N5110 &lcd, SHIP shipUsed);
    /** A mutator method that updates the x and y cursor values based on joystick movemnt
    *@param d the current direction of the joystick
    *@param joystick a 2D vector of the x and y joystick value
    */
    void update(Direction d,Vector2D joystick);
    /** Accessor method to get tthe current ycursor position used to select options
    *from the menu
    *@returns the ycursor value
    */
    int get_ycursor();
    /** Accessor method to get the current xcursor position used to select a ship
    *in the ship section of the menu
    *@returns the xcursor value
    */
    int get_xcursor();
    /** Displays the ship in the menu home screen
    *@param &lcd address of the N5110 library used for the lcd display
    */
    void disp_ships(N5110 &lcd);
    //void Menu::scroll(N5110 &lcd, Direction d);
    
    private:
    //_______________Private-Variables__________________________________________
    int _xcursor; // the x_cursor used in ship select
    int _ycursor; // the y cursor used in main menu

    
};
#endif